<?php
namespace Models;
class Certificates extends \DB\SQL\Mapper{
	public $db, $f3, $sets, $nobt, $epay;

	public function __construct($db, $f3) {
		parent::__construct($db, 'certificates2receipts');
		$this->f3=$f3;
		$this->db=$db;
	}

	function receipt_certificates($receipt_id) {
		return $this->db->exec("SELECT c.*,  p.title FROM certificates2receipts AS c JOIN products AS p ON p.id=c.product_id WHERE c.receipt_id=?", $receipt_id);
	}

	function save_certificate($data) {
		$this->load(array('product_id=? AND certificate=? AND receipt_id=?', array($data['product_id'], $data['certificate'], $data['receipt_id'])), array('limit'=>1));
		$this->copyFrom($data);
		if($this->save()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful'
		);
	}

	function remove_certificate($data) {
		if($this->erase(array('product_id=? AND certificate=? AND receipt_id=?', array($data['product_id'], $data['certificate'], $data['receipt_id'])))===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful'
		);
	}
}