<?php
namespace Controllers;

class Linesset extends Controller {
	
	public function __construct() {
		parent::__construct();
		$this->model=new \Models\Linesset($this->db, $this->f3);
	}

	function list() {
		$page=$this->f3->get('GET.page');
		if(!$page)$page=1;
		$limit=$this->f3->get('lines_of_page');
		$linesset=$this->model->select_linesset(array(), array('offset'=>($page-1)*$limit, 'limit'=>$limit, 'order'=>'title'));
		if($linesset) {
			foreach ($linesset as $n=>$set) {
				$receiptlines=new \Models\Receiptlines($this->db, $this->f3);
				$sum=$receiptlines->get_sum($set['lines']);
				$linesset[$n]['sum']=$sum['sum'];
			}
			$this->f3->set('data', $linesset);
			$this->f3->set('pagination', $this->pagination($this->model->count(), $page));
		}
		$this->f3->set('page_data', $this->model->page_data('list'));
	}

	function show() {
		$id=$this->f3->get('GET.id');
		$linesset=$this->model->select_linesset(array('id=?', $id), array('limit'=>$limit));
		if(!$linesset) {
			$this->f3->set('page_data', $this->messages->message('not_found'));
			return;
		}
		$this->f3->set('data', $linesset[0]);
		$this->f3->set('page_data', $this->model->page_data('show'));
	}

	function delete() {
		$id=$this->f3->get('GET.id');
		$res=$this->model->delete($id);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}
}
