<?php
namespace Models;

// Модель Залов
class Rooms extends \DB\SQL\Mapper {
	public $db, $f3, $tables;

	public function __construct($db, $f3) {
		parent::__construct($db, 'rooms' ); // подключаемся к таблице
		$this->db=$db;
		$this->f3=$f3;
		$this->tables=new \Models\Tables($db, $f3); // модель столов
	}

	// Информация об открываемой странице
	function page_data($page='sales') {
		$pages=array(
			'add'=>array(
				'title'=>'Добавить зал',
				'inc'=>'rooms_form.htm'
			),
			'change'=>array(
				'title'=>'Редактировать зал',
				'inc'=>'rooms_form.htm'
			),
			'select_table'=>array(
				'title'=>'Продажа',
				'inc'=>'rooms_select_table.htm'
			),
			'select_cashbox'=>array(
				'title'=>'Выбор кассы',
				'inc'=>'rooms_select_cashbox.htm'
			)
		);
		$pages[$page]['page']=$page;
		return $pages[$page];
	}

	// Выбор из базы
	function select_rooms($query=null, $options=null) {
		$this->reset();
		$this->load($query, $options);
		$rooms=array();
		if(!$this->dry()) {
			do {
				$rooms[]=$this->cast();
			}
			while ($this->skip());
		}
		return $rooms;
	}

	// Сохраняем зал
	function save_room($data) {
		if(empty($data['title'])) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		$this->reset();
		$this->load(array('title=? AND id!=?', array($data['title'], $data['id'])), array('limit'=>1));
		if(!$this->dry()) {
			return array(
				'success'=>false,
				'txt'=>'room_is_exists'
			);
		}
		$this->reset();
		if($data['id']) {
			$this->load(array('id=?', $data['id']), array('limit'=>1));
			if(!$this->dry()) $id=$data['id'];
		}
		unset($data['id']);
		$this->copyFrom($data);
		if($this->save()!==false) {
			if(!$id) $id=$this->get('_id');
			return array(
				'success'=>true,
				'txt'=>'save_successful',
				'reload'=>'.rooms_list',
				'close_all_window'=>true,
				'function'=>'open_room("/settings/rooms?id='.$id.'")'
			);
		}
		else {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
	}

	// Удаление зала
	function delete($id) {
		if($id>0) {
			// Проверяем наличие зала
			$this->reset();
			$this->load(array('id=?',$id), array('limit'=>1));
			if($this->dry()) {
				return array(
					'success'=>false,
					'txt'=>'not_found'
				);
			}
			// Проверяем наличие столов, их не должно быть
			$this->tables->reset();
			$this->tables->load(array('room=?', $id));
			if(!$this->tables->dry()) {
				return array(
					'success'=>false,
					'txt'=>'room_is_not_empty'
				);
			}
			if($this->erase()) {
				return array(
					'success'=>true,
					'txt'=>'delete_successful',
					'reload'=>'.rooms_list',
					'close_all_window'=>true,
					'function'=>'open_room("/settings/rooms")'
				);
			}
			else {
				return array(
					'success'=>false,
					'txt'=>'db_error'
				);
			}
		}
		else {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
	}

	function synchronization($ip) {
		$web=\Web::instance();
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query='http://'.$ip.'/multikassa/rooms';
		$request=$web->request($query, $options);
		if(mb_strpos($request['headers'][0], '200')===false && mb_strpos($request['headers'][1], '200')===false) {
			return array(
				'success'=>false,
				'txt'=>'error'
			);
		}
		$json=json_decode($request['body'], true);
		if(!$json['success']) {
			return $json;
		}
		if($json['rooms']) {
			// Удаляем все залы
			$this->db->exec("DELETE FROM rooms");
			// Удаляем все столы
			$this->db->exec("DELETE FROM tables");
			// Обновляем автоинкремент
			$this->db->exec("UPDATE sqlite_sequence SET seq=0 WHERE name='rooms' OR name='tables'");
			// Сохраняем залы
			$sql="INSERT INTO rooms ('id', 'title', 'w', 'l') VALUES ";
			$val=array();
			foreach ($json['rooms'] as $room) {
				if(!empty($val)) $sql.=', ';
				$sql.='(?, ?, ?, ?)';
				array_push($val, $room['id'], $room['title'], $room['w'], $room['l']);
			}
			if($this->db->exec($sql, $val)===false) {
				return array(
					'success'=>false,
					'txt'=>'db_error'
				);
			}
		}
		else {
			return array(
				'success'=>false,
				'txt'=>'not_found'
			);
		}
		if($json['tables']) {
			// Сохраняем столы
			$sql="INSERT INTO tables ('id', 'room', 'title', 'x', 'y') VALUES ";
			$val=array();
			foreach ($json['tables'] as $table) {
				if(!empty($val)) $sql.=', ';
				$sql.='(?, ?, ?, ?, ?)';
				array_push($val, $table['id'], $table['room'], $table['title'], $table['x'], $table['y']);
			}
			if($this->db->exec($sql, $val)===false) {
				return array(
					'success'=>false,
					'txt'=>'db_error'
				);
			}
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reload'=>'.rooms_list',
			'close_all_window'=>true,
			'function'=>'open_room("/settings/rooms?id='.$json['rooms'][0]['id'].'")'
		);
	}
}
