<?php
namespace Models;

// Модель Пользователи
class Users extends \DB\SQL\Mapper {
	public $db, $f3, $groups, $accepts;

	public function __construct($db, $f3) {
		parent::__construct($db, 'users' ); // подключаемся к таблицt пользователей
		$this->db=$db;
		$this->f3=$f3;
		$this->groups=new \Models\Usergroups($this->db, $this->f3); // модель пользовательских групп
		$this->accepts=$this->groups->accepts;
	}

	// данные о страницах
	function page_data($page) {
		$pages=array(
			'autorization'=>array(
				'title'=>'Авторизация пользователя',
				'inc'=>'users_autorization.htm'
			),
			'autorization_continue'=>array(
				'title'=>'Авторизация пользователя',
				'inc'=>'users_autorization_continue.htm'
			),
			'directory'=>array(
				'title'=>'Список пользователей',
				'inc'=>'users_directory.htm'
			),
			'add'=>array(
				'title'=>'Добавить пользователя',
				'inc'=>'users_form.htm'
			),
			'change'=>array(
				'title'=>'Редактировать пользователя',
				'inc'=>'users_form.htm'
			),
			'kiosklogout'=>array(
				'title'=>'Выход из режима киоска',
				'inc'=>'users_kiosklogout.htm'
			),
		);
		$pages[$page]['page']=$page;

		return $pages[$page];
	}

	// Выбор из базы
	function select_users($query=null, $options=null) {
		if(!$query) {
			$query=array('u.id>?', 0); // чтобы хоть что-то вставить в фильтры
		}

		// формируем сортировку и лимиты
		$option='';
		if($options['order']) {
			$option.=' ORDER BY '.$options['order'];
		}
		if($options['limit']) {
			$option.=' LIMIT '.$options['limit'];
		}
		// собственно сам запрос
		$sql="SELECT u.*, g.title AS `group_title`, g.module FROM `users` AS `u` JOIN `usergroups` AS `g` ON g.id=u.group_id WHERE u.date_delete=0 AND ".$query[0].$option;
		$res=$this->db->exec($sql, $query[1]);
		$users=array();
		foreach($res as $user) {
			if($user['name']=='') $user['name']='Без имени';
			if($user['short_name']=='') $user['short_name']='Без имени';
			$users[]=$user;
		}
		return $users;
	}

	// Устанавливаем права пользователя
	function users_modules($m) {
		$modules=json_decode($m, true);
		$modules[]='products/stoplist';
		if(!in_array('receipts/reports', $modules)) {
			if(in_array('changes/x', $modules) || in_array('changes/z', $modules) || in_array('changes/search', $modules) || in_array('changes/open', $modules)) {
				$modules[]='receipts/reports';
			}
		}

		// Если можно добавлять товары в чек, то можно и добавлять модификаторы
		if(in_array('receipts/add_line', $modules)) {
			$modules[]='receipts/modifiers';
		}

		if(in_array('receipts/fr_no', $modules)) {
			unset($modules[array_search('receipts/fr_no', $modules)]);
		}
		else {
			$modules[]='receipts/fr_no';
		}

		// Если можно продавать или возвращать, то можно перемещать чек на другой стол и фискализировать документы удаленно,
		// и указывать маркировку товара
		// и вскрывать бутылки
		// и даже устанавливать очереди
		if(in_array('receipts/sales', $modules) || in_array('receipts/return', $modules)) {
			$modules[]='receipts/move';
			$modules[]='receipts/print_turn';
			$modules[]='receipts/add_from_agorta';
			$modules[]='receipts/online_order';
			$modules[]='receipts/show_online_order';
			$modules[]='receipts/search_online_order';
			$modules[]='receipts/fiscalization';
			$modules[]='receipts/add_marking';
			$modules[]='receipts/add_cocktail_line';
			$modules[]='receipts/bonus_pay';
			$modules[]='receipts/turn';
			$modules[]='receipts/description';
			$modules[]='receipts/product_search';
			$modules[]='products/pricetags';
			$modules[]='receipts/pricetags';
			$modules[]='linesset/list';
			$modules[]='linesset/show';
			$modules[]='linesset/delete';
			$modules[]='receipts/add_linesset';
			$modules[]='receipts/selectbarcode';
			$modules[]='receipts/printpricetags';
			$modules[]='receipts/show_qr';
			$modules[]='receipts/paycontrol_qr';
			$modules[]='receipts/print_qr';
			$modules[]='receipts/success_pay';
			$modules[]='receipts/add_combo';
			$modules[]='receipts/split';
			$modules[]='receipts/merge';
			$modules[]='receipts/splitsno';
			$modules[]='receipts/snoerror';
			$modules[]='receipts/select_tap';
			$modules[]='products/compound';
			$modules[]='receipts/printdoc';
			$modules[]='receipts/pdf';
		}

		if(in_array('changes/z', $modules)) {
			$modules[]='receipts/salesreport';
		}

		if(in_array('receipts/certificates', $modules)) {
			$modules[]='receipts/add_certificate';
			$modules[]='receipts/remove_certificate';
		}

		if(in_array('receipts/delete_line', $modules)) {
			$modules[]='receipts/delete_product';
		}

		if(in_array('receipts/correct', $modules)) {
			$modules[]='receipts/correct1';
			$modules[]='receipts/correct2';
		}

		$fr=$this->db->exec("SELECT id FROM fr_settings WHERE printer='kkm' AND active='1' AND type='1' AND driver='drivers/printers/php_mspos' AND version='1.05' LIMIT 1");
		if($fr && in_array('receipts/correct', $modules)) {
			$modules[]='receipts/correction';
		}

		// Если можно изменять кол-во товара, то можно и взвешивать
		if(in_array('receipts/change_line', $modules)) {
			$modules[]='scales/weight';
			$modules[]='receipts/change_count';
		}

		// Если можно искать интернет-заказы, то можно их и добавлять
		if(in_array('receipts/online_order', $modules)) {
			$modules[]='receipts/show_online_order';
			$modules[]='receipts/search_online_order';
			$modules[]='receipts/online_order_status';
			$modules[]='api/change_order_status';
			$modules[]='api/deliveryaction';
		}

		// Если можно настраивать ККМ, то можно настраивать драйвера, принтер повара и пречеков
		if(in_array('settings/kkm', $modules)) {
			$modules[]='settings/kiosk';
			$modules[]='settings/scaner';
			$modules[]='settings/drivers';
			$modules[]='settings/driversform';
			$modules[]='settings/epay_drivers';
			$modules[]='settings/start_driver';
			$modules[]='settings/kitchen_printer';
			$modules[]='settings/pre_printer';
			$modules[]='settings/bar_printer';
			$modules[]='settings/pricetags_printer';
			$modules[]='settings/bankterminal';
			$modules[]='settings/epays';
			$modules[]='settings/deleteepay';
			$modules[]='settings/cashermenu';
			$modules[]='settings/adminmenu';
			$modules[]='settings/testconnection';
		}

		if(in_array('settings/service', $modules)) {
			$modules[]='settings/ofd';
			$modules[]='settings/kkm_registration';
			$modules[]='settings/closefn';
			$modules[]='settings/epay_close';
		}

		// Если разрешен поиск товаров по штрих-коду, то можно и выбирать товары из списка
		if(in_array('products/search_barcodes', $modules)) {
			$modules[]='products/list';
		}

		if(in_array('products/currentstock', $modules)) {
			$modules[]='products/planstock';
		}

		// Если можно управлять залами, то добавляем соответствующие права на страницы
		if(in_array('settings/rooms', $modules)) {
			$modules[]='rooms/add';
			$modules[]='rooms/delete';
			$modules[]='rooms/synchronization';
		}

		// Если можно управлять столами, то добавляем соответствующие права на страницы
		if(in_array('settings/tables', $modules)) {
			$modules[]='tables/add';
			$modules[]='tables/delete';
		}

		if(in_array('partners/search', $modules)) {
			$modules[]='partners/search_result';
			$modules[]='receipts/add_partner';
		}

		if(in_array('settings/synchronization', $modules)) {
			$modules[]='api/balance';
			$modules[]='api/ordersstatuses';
		}

		if(in_array('api/tickets', $modules)) {
			$modules[]='settings/update_ticket_time';
		}

		if(in_array('settings/base', $modules)) {
			$modules[]='settings/marking';
			$modules[]='chz/lmstatus';
			$modules[]='chz/lminit';
			$modules[]='settings/checktoken';
		}

		if(in_array('egais/main', $modules)) {
			$modules[]='egais/ticket';
			$modules[]='egais/utminfo';
			$modules[]='egais/rests';
			$modules[]='egais/createttn';
			$modules[]='egais/ttnact';
			$modules[]='egais/ttnact_repeal';
			$modules[]='egais/nattn';
			$modules[]='egais/writeoff';
			$modules[]='egais/writeoff_repeal';
			$modules[]='egais/organizations';
			$modules[]='egais/beer_currentstock';
			$modules[]='egais/related';
			$modules[]='egais/send_ttn';
			$modules[]='egais/search_ttn';
			$modules[]='egais/send_replyrests';
			$modules[]='egais/restbcode';
			$modules[]='egais/declaration';
			$modules[]='egais/searchindocs';
		}

		if(in_array('taps/connection', $modules) || in_array('taps/form', $modules) || in_array('taps/delete', $modules)) {
			$modules[]='taps/unconnection';
			$modules[]='taps/move';
			$modules[]='taps/list';
			$modules[]='taps/tap';
			$modules[]='taps/product_add';
			$modules[]='taps/product_delete';
			$modules[]='taps/connection_select_product';
		}

		if(in_array('settings/customer_display', $modules)) {
			$modules[]='settings/pricechecker';
		}

		if(
			in_array('settings/kkm', $modules)
			|| in_array('settings/scales', $modules)
			|| in_array('settings/customer_display', $modules)
			|| in_array('settings/scales', $modules)
		) {
			$modules[]='settings/devices';
		}

		return $modules;
	}

	// проверка на авторизацию
	function is_login() {
		$res=array(); // массив с информацией об аторизованном пользователе
		$hash=$this->f3->get('COOKIE.hash'); // берем данные из сессии
		if(!$hash) {
			return false;
		}
		$res=$this->select_users(array("u.hash=? AND date_delete=0", array($hash)), array('limit'=>1));
		if(empty($res)) {
			return false;
		}

		if($res[0]['module']=='') {
			$res[0]['module']=$this->accepts;
		}
		
		$modules=$this->users_modules($res[0]['module']);
		$res[0]['module']=$modules;

		$this->f3->set('authorization_user', $res[0]); // перезапишем информацию об авторизации
		return true;
	}

	// авторизация пользователя
	function user_autorization($post) {
		if(!isset($post['user_pass'])) { // проверяем наличие всех нужных данных
			return array( // если чего-то не хватает, то сообщаем об ошибке
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		$res=array();
		// Проверяем что введено логин и пароль или штрих-код сотрудника
		$search_barcode=false;
		$s=new \Models\Settings($this->f3, $this->db);
		$sets=$s->get_settings(array('worker_code_pr'));

		if(($post['user_pass'] && !isset($post['user_id'])) || (mb_strlen($post['user_pass'])==13 && mb_substr($post['user_pass'], 0, 2)==$sets['worker_code_pr'])) {
			// Ищем по штрих коду
			$search_barcode=true;
			$res=$this->select_users(array('u.card=? AND u.type>=1 AND u.date_delete=0', $post['user_pass']), array('limit'=>1));
		}
		elseif(!isset($post['user_id'])) { // проверяем наличие всех нужных данных
			return array( // если чего-то не хватает, то сообщаем об ошибке
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		if(empty($res)) {

			$res=$this->select_users(array('u.id=? AND type>=1 AND date_delete=0', $post['user_id']), array('limit'=>1)); // пытаемся найти выбранного пользователя
			if(empty($res)) { // если его нет, то выводим ошибку
				return array(
					'success'=>false,
					'txt'=>'user_not_found',
					'form_reset'=>$search_barcode
				);
			}

			if($post['user_pass']!=$res[0]['pass']) { // проверяем пароли
				return array(
					'success'=>false,
					'txt'=>'pass_incorrect',
					'form_reset'=>$search_barcode
				);
			}
		}

		// Проверяем хэш
		/*if($post['forcibly']==0 && $res[0]['hash']!='') {
			return array(
				'success'=>false,
				'txt'=>'autorization_is_already_done',
				'next_step'=>'/users/autorization_continue'
			);
		}*/

		if($res[0]['module']=='') {
			$res[0]['module']=$this->accepts;
		}
		$modules=$this->users_modules($res[0]['module']);
		$res[0]['module']=$modules;

		// Создаем хэш авторизации
		$res[0]['hash']=time().'-'.md5($res[0]['name'].time());
		// Обновляем хэш в базе
		$this->save_user($res[0], 'change');

		$this->f3->set('authorization_user', $res[0]); // если все ок, то запоминаем информацию о пользователе
		$this->f3->set('COOKIE.hash', $res[0]['hash']);
		$url='/';
		if($this->f3->get('QUERY') && !$this->f3->get('GET.not_ajax')) {
			$url='/receipts/add_from_agorta?'.$this->f3->get('QUERY');
		}
		return array(
			'success'=>true,
			'txt'=>'login_successful',
			'reroute'=>$url
		);
	}

	// Выход из системы
	function logout() {
		$this->reset();
		$this->load(array('id=?', $this->f3->get('authorization_user.id')), array('limit'=>1));
		if(!$this->dry()) {
			$this->hash='';
			$this->update();
		}
		$cookie=$this->f3->get('COOKIE');
		if($cookie) {
			foreach ($cookie as $key => $value) {
				$this->f3->clear('COOKIE.'.$key);
			}
		}
		$this->f3->clear('authorization_user');
		return array(
			'success'=>true,
			'txt'=>'logout_successful',
			'reroute'=>'/users/autorization'
		);
	}

	// Сохранение пользователя
	function save_user($data, $action='add') {
		if(isset($data['surname']) && isset($data['name'])) {
			$data['surname']=trim($data['surname']);
			$data['name']=trim($data['name']);
			$data['second_name']=trim($data['second_name']);
			if(!$data['surname'] || !$data['name']) {
				return array(
					'success'=>false,
					'txt'=>'not_enough_data'
				);
			}
			$data['short_name']=$data['surname'].' '.mb_substr($data['name'], 0, 1).'.';
			if($data['second_name']) {
				$data['short_name'].=' '.mb_substr($data['second_name'], 0, 1).'.';
			}
			$data['name']=trim($data['surname'].' '.$data['name'].' '.$data['second_name']);
		}

		if(!isset($data['name']) || !isset($data['group_id'])) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		$this->reset();
		$data['name']=trim($data['name']);
		if($action=='change' && $data['id']) {
			$this->load(array('id=?', $data['id']));
			if(!$data['pass']) $data['pass']=$this->pass;
		}
		if(!$data['id']) {
			$data['id']=$this->db->exec("SELECT MAX(id) AS max_id FROM users")[0]['max_id']+1;
			$data['date_delete']=0;
		}

		$this->copyFrom($data);
		if($this->save()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		$this->reset();
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reload'=>array('.users'),
			'close_all_window'=>true
		);
	}

	function delete($id) {
		$this->reset();
		if(!$id) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		$this->load(array('id=?', $id), array('limit'=>1));
		if($this->dry()) {
			return array(
				'success'=>false,
				'txt'=>'not_found'
			);
		}
		if($this->hash==$this->f3->get('COOKIE.hash')) {
			return array(
				'success'=>false,
				'txt'=>'not_delete_myself'
			);
		}
		$this->date_delete=microtime(true);
		if($this->update()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reload'=>array('.users')
		);
	}
}
