<?php

if(!file_exists('app/api_config.php')) {
	header('Location: /');
	exit();
}
include('app/api_config.php');
$ini=parse_ini_file('app/config.ini');
$version=$ini['site_version'];
$db_name='cashbox.sqlite';
if($ini['agorta_url']) {
	$url = $ini['agorta_url'].'/api/update?soft=1&version='.$version;
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,  2);

	$json = curl_exec($ch);
	curl_close($ch);
	$result=json_decode($json, true);
}
else {
	$result=null;
}
$dir='backups';
$backup_folder=$dir.'/'.date("Y-m-d-H-i-s").'v'.$version.'/';
$instal=$_GET['instal']; // Какую версию надо установить

$backup=$_GET['backup']; // Надо ли сделать только резервную копию

function backup($folder, $backup_folder, $delete=false) {
	global $db_name;
	$files=scandir($folder);
	foreach ($files as $f) {
		if($f!='.' && $f!='..' && $f!='backups' && $f!='tmp' && $f!='.git') {
			if(!is_dir($folder.$f)) {
				if(!copy($folder.$f, $backup_folder.$f)) {
					echo'<p>Возникала ошибка при копировании файла '.$folder.$f.'</p>';
					exit();
				}
				if($f!='api_config.php' && $f!=$db_name && $f!='update.php' && $f!='server.config.bak' && $f!='pre_server.config.bak' && $f!='kitchen_server.config.bak' && $f!='bar_server.config.bak') {
					if($delete===true) {
						if($f=='server.config' || $f=='pre_server.config' || $f=='kitchen_server.config' || $f=='bar_server.config' || $f=='pricetags_server.config') {
							copy($folder.$f, $folder.$f.'.bak');
						}
						unlink($folder.$f);
						@rmdir($folder);
					}
				}
			}
			else {
				@mkdir($backup_folder.$f, 0777, true);
				chmod($backup_folder.$f, 0777);
				backup($folder.$f.'/', $backup_folder.$f.'/', $delete);
				if($f!='db' && $f!='.git') {
					if($delete===true) {
						@rmdir($folder.$f);
					}
				}
			}
		}
	}
}

function server_config($folder) {
	$dirs=scandir($folder);
	if(!is_array($dirs)) return;
	foreach ($dirs as $d) {
		$f=$folder.'/'.$d;
		if(is_dir($f)) {
			if(file_exists($f.'/server.config') && file_exists($f.'/server.config.bak')) {
				rename($f.'/server.config', $f.'/server.config.default');
				rename($f.'/server.config.bak', $f.'/server.config');
			}
			if(file_exists($f.'/pre_server.config.bak')) {
				rename($f.'/pre_server.config.bak', $f.'/pre_server.config');
			}
			if(file_exists($f.'/kitchen_server.config.bak')) {
				rename($f.'/kitchen_server.config.bak', $f.'/kitchen_server.config');
			}
			if(file_exists($f.'/bar_server.config.bak')) {
				rename($f.'/bar_server.config.bak', $f.'/bar_server.config');
			}
			if(file_exists($f.'/pricetags_server.config.bak')) {
				rename($f.'/pricetags_server.config.bak', $f.'/pricetags_server.config');
			}
		}
	}
}

if($backup=='true') {
	// Делаем бэкап
	if(!file_exists($dir)) {
		mkdir($dir, 0777, true);
		chmod($dir, 0777);
	}
	if(!file_exists($backup_folder)) {
		mkdir($backup_folder, 0777, true);
		chmod($backup_folder, 0777);
	}
	backup($_SERVER["DOCUMENT_ROOT"].'/', $_SERVER["DOCUMENT_ROOT"].'/'.$backup_folder, false);
	header('Location: /update.php');
	exit();
}
if(($result['success'] && $result['version']['version']==$instal) || $_FILES['file']['tmp_name']!='') { // Установка обновления
	// Делаем бэкап
	if(!file_exists($dir)) {
		mkdir($dir, 0777, true);
		chmod($dir, 0777);
	}
	if(!file_exists($backup_folder)) {
		mkdir($backup_folder, 0777, true);
		chmod($backup_folder, 0777);
	}
	backup($_SERVER["DOCUMENT_ROOT"].'/', $_SERVER["DOCUMENT_ROOT"].'/'.$backup_folder, true);

	if($_FILES['file']['tmp_name']) {
		$archive='next_version.zip';
		copy($_FILES['file']['tmp_name'], $archive);
	}
	else {
		// Скачиваем архив с новой версией
		$ch = curl_init();
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	    curl_setopt($ch, CURLOPT_HEADER, false);
	    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	    curl_setopt($ch, CURLOPT_URL, $result['version']['file']);
	    curl_setopt($ch, CURLOPT_REFERER, $result['version']['file']);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	    $output = curl_exec($ch);
	    curl_close($ch);
		$ext=pathinfo($result['version']['file'], PATHINFO_EXTENSION);
		$archive="next_version.".$ext;
		$fh = fopen($archive, 'w');
		fwrite($fh, $output);
		fclose($fh);
	}

	// Распаковываем архив с новой версией
	$zip = new ZipArchive(); //Создаём объект для работы с ZIP-архивами
  	//Открываем архив archive.zip и делаем проверку успешности открытия
  	if($zip->open($archive)) {
    	$zip->extractTo($_SERVER["DOCUMENT_ROOT"]); //Извлекаем файлы в указанную директорию
    	$zip->close(); //Завершаем работу с архивом
    	unlink($archive);
    	if(file_exists('app/db_update.php')) {
    		// обновляем базу данных
    		$db = new SQLite3($ini['db_name'], SQLITE3_OPEN_READWRITE);
    		include('app/db_update.php');
    		unlink('app/db_update.php');
    	}
    	// Восстанавливаем настройки драйверов
    	server_config('drivers/displays');
    	server_config('drivers/printers');
    	server_config('drivers/scales');
    	server_config('drivers/epays');
    	header('Location: /update.php');
    	exit();
    }
    else {
    	echo "<p>Ошибка с архивом</p>";
    }
}

// Восстановление из бэкапа
if($instal && is_dir($dir.'/'.$instal)) {
	$bdb=$_GET['db'];
	// Удаляем все
	function delete_folders($folder) {
		global $bdb;
		$files=scandir($folder);
		foreach ($files as $f) {
			if($f!='.' && $f!='..' && $f!='backups') {
				if(!is_dir($folder.$f)) {
					unlink($folder.$f);
					@rmdir($folder);
				}
				else {
					if($bdb || $f!='db') {
						delete_folders($folder.$f.'/');
						@rmdir($folder.$f);
					}
				}
			}
		}
	}
	delete_folders($_SERVER["DOCUMENT_ROOT"].'/');

	// восстанавливаем из папки
	function restore($restore_folder, $folder) {
		global $bdb;
		$files=scandir($restore_folder);
		foreach ($files as $f) {
			if($f!='.' && $f!='..') {
				if(!is_dir($restore_folder.$f)) {
					if(!copy($restore_folder.$f, $folder.$f)) {
						echo'<p>Возникла ошибка при копировании файла '.$restore_folder.$f.'</p>';
						exit();
					}
				}
				else {
					if($bdb || $f!='db') {
						@mkdir($folder.$f, 0777, true);
						chmod($folder.$f, 0777);
						restore($restore_folder.$f.'/', $folder.$f.'/');
					}
				}
			}
		}
	}
	restore($_SERVER["DOCUMENT_ROOT"].'/'.$dir.'/'.$instal.'/', $_SERVER["DOCUMENT_ROOT"].'/');
	header('Location: /update.php');
	exit();
}

?>
<!DOCTYPE html>
<html lang="ru">
	<head>
		<meta charset="utf-8" />
		<title>Обновление программы</title>
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<link rel="apple-touch-icon" sizes="180x180" href="/ui/css/img/apple-touch-icon.png?v={{@site_version}}">
		<link rel="icon" type="image/png" sizes="32x32" href="/ui/css/img/favicon-32x32.png?v={{@site_version}}">
		<link rel="icon" type="image/png" sizes="16x16" href="/ui/css/img/favicon-16x16.png?v={{@site_version}}">
		<link rel="manifest" href="/ui/css/img/site.webmanifest?v={{@site_version}}">
		<link rel="mask-icon" href="/ui/css/img/safari-pinned-tab.svg?v={{@site_version}}" color="#5bbad5">
		<meta name="apple-mobile-web-app-title" content="Агорта.Касса">
		<meta name="application-name" content="Агорта.Касса">
		<meta name="msapplication-TileColor" content="#ffffff">
		<meta name="theme-color" content="#ffffff">
	</head>
	<body>
<?

echo '<a href="/"><input type="button" value="Вернуться"></a>';
echo"<p>Текущая версия ".$version.". <a href='/update.php?backup=true'><input type=button value='Сделать резервную копию'></a></p>";
echo'<form action="/update.php" method="POST" enctype="multipart/form-data">';
echo'<p>Обновить из файла <input type="file" name="file" accept=".zip"><input type="submit" value="Обновить"></p>';
echo'</form>';
if($result['success']) {
	echo "<p>Доступно обновление ".$result['version']['title']." ".$result['version']['version']." <a href=/update.php?instal=".$result['version']['version']."><input type=button value=Установить></p></a>";
}
elseif($result['error']) {
	echo $result['error'];
}

// Показываем предыдущии версии
if(file_exists($dir)) {
	$backups=scandir($dir);
	if(count($backups)>2) {
		echo"<br><p>Восстановить предыдущую версию</p>";
		foreach ($backups as $f) {
			if($f!='.' && $f!='..') {
				$f_name=explode('v', $f);
				$time=explode('-', $f_name[0]);
				if($f_name) {
					echo "<p>Архив от ".$time[2].'.'.$time[1].'.'.$time[0].' '.$time[3].':'.$time[4].':'.$time[5].' версия '.$f_name[1].' <a href="/update.php?instal='.$f.'"><input type="button" value="Восстановить без БД"></a> <a href="/update.php?instal='.$f.'&db=1"><input type="button" value="Восстановить с БД"></a>';
				}
				else {
					echo "<p>Архив от ".$f.' <a href="/update.php?instal='.$f.'"><input type="button" value="Восстановить без БД"></a> <a href="/update.php?instal='.$f.'&db=1"><input type="button" value="Восстановить с БД"></a>';
				}
			}
		}
	}
}
?>
		<script type="text/javascript" src="/ui/scripts/jquery-3.3.1.min.js"></script>
		<script type="text/javascript">
			$('input[type="button"], input[type="submit"]').click(function(){
				if($(this).attr('type')=='submit') {
					$(this).closest('form').submit();
				}
				$('input[type="button"], input[type="submit"]').attr('disabled', true);
			});
		</script>
	</body>
</html>