// Выбор зала
function open_room(href, menu=true) {
  show_window('loading', loading_txt);
  if($('#select_room').length>0) {
    $('#select_room').load(href+' #select_room .reload', function(){
      if($('.room').length==0) location.reload();
      close_window('#loading');
      resize_rooms();
    });
  }
  else {
    $('#screen').load(href+' #screen_window', function(){
      if($('table.room').length==0) location.reload();
      close_window('#loading');
      resize_rooms();
    });
  }
  if(menu) {
    $('#room_menu').load(href+' #room_menu > .first_menu');
  }
}

function resize_rooms() {
  var w=210;
  var h=60;
  if($('body').width()<961) {
    w=0;
    h=89;
  }
  if($('#room_id').length>0) {
    h+=100;
  }

  if($('.room_item button').length<2) {
    w=0;
    h=0;
    $('#select_room').css("margin-left", 0);
  }

  w=$('body').width()-w;
  h=$('body').height()-h;
  $('#select_room').css("width", 'auto');
  $('#select_room').css("height", 'auto');
  
  $('#select_room').css("max-width", w);
  $('#select_room').css("max-height", h);
}

if($('#select_room').length>0) {
  resize_rooms();
}

$('body').off('click', '.room_item');
$('body').on('click', '.room_item', function(e){
  e.preventDefault();
  var href=$(this).attr('href');
  open_room(href, true);
});

$('body').off('change', '#room_id');
$('body').on('change', '#room_id', function(){
  var href=$(this).val();
  open_room(href, false);
});

// Нажатие на клетку зала
$('body').off('click', '#select_room .room_ceil:not(.dinner_move)');
$('body').on('click', '#select_room .room_ceil:not(.dinner_move)', function(){
  var data=$('input[type="checkbox"]', this).val();
  load_window('/tables/add?data='+data);
});

// Добавление стола в зал
function add_table(data) {
  var isJson = true;
    var res;
    try {
      res=JSON.parse(data);
  } catch(e) {
    isJson = false;
  }
    if(isJson) {
      var checkbox='#'+res.room+'-'+res.x+'-'+res.y;
    $(checkbox).prop('checked', true);
    $(checkbox).val(res.room+'-'+res.x+'-'+res.y+'-'+res.id);
    var div=$(checkbox).parent('.dinner_table');
    div.addClass('dinner_table_show');
    $('.dinner_table_title', div.parent('.room_ceil')).html(res.title);
  }
    else {
      show_window(null, data);
  }
}

// Удаляем стол из зала
function delete_table(data) {
  var isJson = true;
    var res;
    try {
      res=JSON.parse(data);
  } catch(e) {
    isJson = false;
  }
    if(isJson) {
      var checkbox='#'+res.room+'-'+res.x+'-'+res.y;
    $(checkbox).prop('checked', false);
    $(checkbox).val(res.room+'-'+res.x+'-'+res.y+'-0');
    var div=$(checkbox).parent('.dinner_table');
    div.removeClass('dinner_table_show');
    $('.dinner_table_title', div.parent('.room_ceil')).html('&nbsp;');
  }
    else {
      show_window(null, data);
  }
}

// Перемещение стола
var dinner_table_title;
$('body').off('click', 'input[name="dinner_table_move"]');
$('body').on('click', 'input[name="dinner_table_move"]', function(){
  // Отображаем зал поверх всех окон
  $('#select_room .reload').addClass('popup');
  $('#select_room .reload .room_div').addClass('popup_area');

  // Указываем, что в ячейки стол не добавляется, а перемещается, добавляем класс
  $('.room_ceil').addClass('dinner_move');
  // Данные о перемещаемом столе
  var room=$('input[name="room"]').val();
  var x=$('input[name="x"]').val();
  var y=$('input[name="y"]').val();
  dinner_table_title=$('input[name="title"]').val();
  // Находим перемещаемый стол и скрываем его
  var room_ceil=$('#'+room+'-'+x+'-'+y).closest('.room_ceil');
  $('.dinner_table_title', room_ceil).html('');
  $('.dinner_table', room_ceil).removeClass('dinner_table_show');
  $('#'+room+'-'+x+'-'+y).prop('checked', false);
});

// Поведение мыши с ячейками для перемещения стола
$('body').off('mouseover', '.dinner_move');
$('body').on('mouseover', '.dinner_move', function(){
  if(!$('input[type="checkbox"]', this).prop('checked')) {
    $('.dinner_table_title', this).html(dinner_table_title);
  }
});

$('body').off('mouseout', '.dinner_move');
$('body').on('mouseout', '.dinner_move', function(){
  if(!$('input[type="checkbox"]', this).prop('checked')) {
    $('.dinner_table_title', this).html('');
  }
});

// Закрытие окна для перемещения стола
function close_room_for_move() {
  // Отображаем зал как прежде
  $('#select_room .reload').removeClass('popup');
  $('#select_room .reload .room_div').removeClass('popup_area');

  // Указываем, что в ячейки столы можно добавлять
  $('.room_ceil').removeClass('dinner_move');
  // Данные о перемещаемом столе
  var room=$('input[name="room"]').val();
  var x=$('input[name="x"]').val();
  var y=$('input[name="y"]').val();
  // Находим перемещаемый стол и показываем его
  var room_ceil=$('#'+room+'-'+x+'-'+y).closest('.room_ceil');
  $('.dinner_table_title', room_ceil).html(dinner_table_title);
  $('.dinner_table', room_ceil).addClass('dinner_table_show');
  $('#'+room+'-'+x+'-'+y).prop('checked', true);
}

$('body').off('click', '#select_room .close_button');
$('body').on('click', '#select_room .close_button', function(){
  close_room_for_move();
});

// Нажатие на ячейку для перемещения стола
$('body').off('click', '.dinner_move');
$('body').on('click', '.dinner_move', function(){
  if($('input[type="checkbox"]', this).prop('checked')) return;
  close_room_for_move();
  $('.dinner_table_title', this).html('');
  var val=$('input[type="checkbox"]', this).val().split('-');
  $('input[name="x"]').val(val[1]);
  $('input[name="y"]').val(val[2]);
  $('form[name="tables_form"]').submit();
});

// Выбор стола
$('body').off('click', '.room_ceil_select');
$('body').on('click', '.room_ceil_select', function(){
  var checkbox=$('input[type="checkbox"]', this);
  if(!checkbox.prop('checked')) return;
  var val=checkbox.val().split('-');
  var table_id=val[3];
  if($(this).hasClass('move')) {
    load_ajax('/messages/continue?uri='+encodeURIComponent('/receipts/move?table_id='+table_id));
    return;
  }
  show_window();
  $('#screen').load(location.pathname+'?table_id='+table_id+' #screen_window', function(){
    receiptlines_div_resize();
    close_all_window();
  });
});

function reload_rooms() {
  if($('#select_room').length>0 && $('#room_for_move').length==0) {
    $('#select_room').load('?room_id='+$('#select_room .reload').attr('data-room')+' #select_room .reload', function(){
      if($('table.room').length==0) location.reload();
    });
  }
}
if($('#rooms_menu').length==0) {
  setInterval('reload_rooms()', 5000);
}

$('body').off('click', '#rooms_menu_show');
$('body').on('click', '#rooms_menu_show', function(){
  $('#rooms_menu').toggleClass('rooms_menu_show_all');
});
