<?php
namespace Models;

// Модель Пользовательских групп
class Usergroups extends \DB\SQL\Mapper {
	public $db, $f3, $accepts;

	public $modules=array(
		'receipts/return'=>array('title'=>'Возврат', 'autonomous'=>true),
		'receipts/sales'=>array('title'=>'Продажа', 'autonomous'=>true),
		'receipts/correct'=>array('title'=>'Чеки коррекции', 'autonomous'=>true),
		'receipts/new'=>array('title'=>'Открытие нескольких чеков', 'autonomous'=>true),
		'receipts/all_open'=>array('title'=>'Показ всех чеков', 'autonomous'=>true),
		'receipts/switch'=>array('title'=>'Переключение на другой чек', 'autonomous'=>true),
		'receipts/intercept'=>array('title'=>'Перехват чека', 'autonomous'=>true),
		'receipts/add_line'=>array('title'=>'Добавить товар в чек', 'autonomous'=>true),
		'receipts/freesales'=>array('title'=>'Свободная продажа', 'autonomous'=>true),
		'receipts/chpok'=>array('title'=>'Вскрытие тары', 'autonomous'=>true),
		'taps/connection'=>array('title'=>'Подключение кега', 'autonomous'=>true),
		'taps/form'=>array('title'=>'Добавление кранов для розлива', 'autonomous'=>true),
		'taps/delete'=>array('title'=>'Удаление кранов для розлива', 'autonomous'=>true),
		'receipts/change_line'=>array('title'=>'Изменение кол-ва в чеке', 'autonomous'=>true),
		'receipts/change_price'=>array('title'=>'Изменение цены товара в чеке', 'autonomous'=>true),
		'receipts/bonus_writeoff'=>array('title'=>'Изменять цену товара списанием баллов', 'autonomous'=>true),
		'receipts/ignore_max_discount'=>array('title'=>'Игнорировать макс. скидку при изменени цены', 'autonomous'=>true),
		'receipts/delete_line'=>array('title'=>'Удалить товар из чека', 'autonomous'=>true),
		'receipts/select_discount'=>array('title'=>'Установка скидки на чек из списка скидок', 'autonomous'=>false),
		'receipts/discount'=>array('title'=>'Установка произвольной скидки на чек', 'autonomous'=>true),
		'partners/search'=>array('title'=>'Добавление клиента в чек', 'autonomous'=>false),
		'receipts/remove_partner'=>array('title'=>'Удаление клиента из чека', 'autonomous'=>false),
		'receipts/pay'=>array('title'=>'Оплата чека', 'autonomous'=>true),
		'receipts/fr_no'=>array('title'=>'Тестовая операция', 'autonomous'=>true),
		'receipts/hold'=>array('title'=>'Пробитие чека при ошибке ФР', 'autonomous'=>true),
		'receipts/search'=>array('title'=>'Поиск чеков', 'autonomous'=>true),
		'receipts/show'=>array('title'=>'Просмотр чеков', 'autonomous'=>true),
		'receipts/new_card'=>array('title'=>'Добавление нового клиента', 'autonomous'=>false),
		'receipts/online_order'=>array('title'=>'Добавлять заказы из интернет-магазина', 'autonomous'=>false),
		'products/form'=>array('title'=>'Добавлять новые товары', 'autonomous'=>true),
		'products/fast_products'=>array('title'=>'Быстрые товары', 'autonomous'=>true),
		'products/search_barcodes'=>array('title'=>'Поиск товаров', 'autonomous'=>true),
		'products/img'=>array('title'=>'Просмотр изображений', 'autonomous'=>false),
		'products/currentstock'=>array('title'=>'Просмотр остатков', 'autonomous'=>false),
		'products/show_buy_price'=>array('title'=>'Отображать закупочную цену', 'autonomous'=>false),
		'egais/main'=>array('title'=>'Работа с ЕГАИС', 'autonomous'=>true),
		'receipts/cashin'=>array('title'=>'Добавление в кассу', 'autonomous'=>true),
		'receipts/cashout'=>array('title'=>'Изъятие из кассы', 'autonomous'=>true),
		'receipts/reports'=>array('title'=>'Отчет по сменам', 'autonomous'=>true),
		'changes/open'=>array('title'=>'Открытие смены', 'autonomous'=>true),
		'changes/search'=>array('title'=>'Поиск смен', 'autonomous'=>true),
		'changes/x'=>array('title'=>'X-отчет', 'autonomous'=>true),
		'changes/z'=>array('title'=>'Закрытие смены', 'autonomous'=>true),
		'changes/close_alert'=>array('title'=>'Закрытие смены при открытых чеках', 'autonomous'=>true),
		'settings/reset'=>array('title'=>'Сброс настроек', 'autonomous'=>true),
		'settings/base'=>array('title'=>'Настройки кассовой программы', 'autonomous'=>true),
		'settings/api'=>array('title'=>'Настройки API', 'autonomous'=>true),
		'settings/autonomous'=>array('title'=>'Настройки автономного режима', 'autonomous'=>true),
		'settings/kkm'=>array('title'=>'Настройки ККМ', 'autonomous'=>true),
		'settings/customer_display'=>array('title'=>'Настройки дисплея покупателя', 'autonomous'=>true),
		'settings/scales'=>array('title'=>'Настройки весов', 'autonomous'=>true),
		'settings/synchronization'=>array('title'=>'Настройки синхронизации', 'autonomous'=>true),
		'settings/logs'=>array('title'=>'Список ошибок', 'autonomous'=>true),
		'settings/rooms'=>array('title'=>'Настройка залов в режиме ресторана', 'autonomous'=>true),
		'settings/tables'=>array('title'=>'Настройка столов в режиме ресторана', 'autonomous'=>true),
		'productcategories/directory'=>array('title'=>'Список категорий номенклатуры', 'autonomous'=>true),
		'productcategories/form'=>array('title'=>'Создание и редактирование категорий номенклатуры', 'autonomous'=>true),
		'productcategories/delete'=>array('title'=>'Удаление категорий номенклатуры', 'autonomous'=>true),
		'products/directory'=>array('title'=>'Список номенклатуры', 'autonomous'=>true),
		'products/form'=>array('title'=>'Создание и редактирование номенклатуры', 'autonomous'=>true),
		'products/delete'=>array('title'=>'Удаление номенклатуры', 'autonomous'=>true),
		'usergroups/directory'=>array('title'=>'Список групп пользователей', 'autonomous'=>true),
		'usergroups/form'=>array('title'=>'Создание и редактирование групп пользователей', 'autonomous'=>true),
		'usergroups/delete'=>array('title'=>'Удаление групп пользователей', 'autonomous'=>true),
		'users/directory'=>array('title'=>'Список пользователей', 'autonomous'=>true),
		'users/form'=>array('title'=>'Создание и редактирование пользователей', 'autonomous'=>true),
		'users/delete'=>array('title'=>'Удаление пользователей', 'autonomous'=>true),
		'api/products_all'=>array('title'=>'Синхронизация товаров', 'autonomous'=>false),
		'api/users'=>array('title'=>'Синхронизация пользователей', 'autonomous'=>false),
		'api/partners_all'=>array('title'=>'Синхронизация клиентов', 'autonomous'=>false),
		'api/tickets'=>array('title'=>'Синхронизация чеков', 'autonomous'=>false),
		'api/barcodes_pr'=>array('title'=>'Синхронизация префиксов штрих-кодов', 'autonomous'=>false),
		'api/logs'=>array('title'=>'Синхронизация ошибок синхронизации', 'autonomous'=>false),
		'api/sno'=>array('title'=>'Синхронизация СНО', 'autonomous'=>false),
		'api/loyalty'=>array('title'=>'Синхронизация программ лояльности', 'autonomous'=>false),
		'api/get_remote_receipts'=>array('title'=>'Запрашивать чеки на удаленную фискализацию', 'autonomous'=>false),
		'settings/service'=>array('title'=>'Сервисное обслуживание', 'autonomous'=>true),
		'changes/open_fr'=>array('title'=>'Открытие смены на ФР', 'autonomous'=>true),
		'changes/open_db'=>array('title'=>'Открытие смены на Кассе', 'autonomous'=>true),
		'changes/close_fr'=>array('title'=>'Закрытие смены на ФР', 'autonomous'=>true),
		'changes/close_db'=>array('title'=>'Закрытие смены на Кассе', 'autonomous'=>true),
		'receipts/print_last'=>array('title'=>'Печать копии последнего чека', 'autonomous'=>true),
		'settings/status_kkm'=>array('title'=>'Запрос полного статуса ККМ', 'autonomous'=>true),
		'settings/continue_print'=>array('title'=>'Выход из аварийного состояния ККМ', 'autonomous'=>true),
		'settings/reset_ticket'=>array('title'=>'Аннулирование чека', 'autonomous'=>true)
	);

	public function __construct($db, $f3=null) {
		parent::__construct($db, 'usergroups' ); // подключаемся к таблице пользовательских групп
		$this->db=$db;
		$this->f3=$f3;
		$this->accepts=json_encode(array_keys($this->modules));
	}

	// данные о страницах
	function page_data($page) {
		$pages=array(
			'directory'=>array(
				'title'=>'Список групп пользователей',
				'inc'=>'usergroups_directory.htm'
			),
			'add'=>array(
				'title'=>'Добавить группу пользователей',
				'inc'=>'usergroups_form.htm'
			),
			'change'=>array(
				'title'=>'Редактировать группу пользователей',
				'inc'=>'usergroups_form.htm'
			)
		);
		$pages[$page]['page']=$page;

		return $pages[$page];
	}

	// Сохранение группы
	function save_group($data, $action='add') {
		if(!isset($data['title'])) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}

		$this->reset();
		if($action=='change' && $data['id']) {
			$this->load(array('id=?', $data['id']));
		}

		if(!$data['id']) {
			$this->load(null, array('limit'=>1, 'order'=>'id DESC'));
			if($this->dry()) $data['id']=1;
			else $data['id']=$this->id+1;
			$this->reset();
		}

		$modules=array_column($this->modules, 'autonomous');
		foreach ($modules as $key => $value) {
			if(!$value) unset($modules[$key]);
		}

		if(!isset($data['module'])) {
			if($data['modules'] && count($data['modules'])==count($modules)) {
				$data['module']='';
			}
			elseif($data['modules']) {
				$data['module']=json_encode($data['modules']);
			}
			else {
				$data['module']='["no"]';
			}
		}

		$this->copyFrom($data);
		if($this->save()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		$this->reset();
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'close_all_window'=>true,
			'reload'=>array('.usergroups')
		);
	}

	function select_groups($query=null, $options=null) {
		$this->reset();
		$this->load($query, $options);
		$groups=array();
		if(!$this->dry()) {
			do {
				$g=$this->cast();
				$g['modules_data']=json_decode($g['module'], true);
				if(!$g['modules_data']) {
					$g['modules_data']=array_keys($this->modules);
				}
				$groups[]=$g;
			}
			while ($this->skip());
		}
		return $groups;
	}

	function delete($id) {
		$this->reset();
		if(!$id) {
			return array(
				'success'=>false,
				'txt'=>'not_enough_data'
			);
		}
		$this->load(array('id=?', $id), array('limit'=>1));
		if($this->dry()) {
			return array(
				'success'=>false,
				'txt'=>'not_found'
			);
		}

		if($this->erase()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful',
			'reload'=>array('.usergroups')
		);
	}
}
