<?php
namespace Models;

// Модель для работы с API
class Api extends Controller {
	public $api_domen, $api_pass, $api_store_id, $api_count, $web;

	public function __construct($f3, $api_domen, $api_pass, $api_store_id, $api_count) {
		parent::__construct($f3);
		$this->api_store_id=$api_store_id;
		$this->api_domen=$api_domen;
		$this->api_domen=str_replace('http://', '', $this->api_domen);
		$this->api_domen=str_replace('https://', '', $this->api_domen);
		$this->api_pass=$api_pass;
		$this->api_count=$api_count;

		if($this->f3->get('HOST')=='kassa.loc') {
			$d=array_reverse(explode('.', $api_domen));
			if($d[0]=='loc' || !$api_domen || $api_domen=='admin.agorta.ru') {
				$this->f3->set('agorta_url', 'http://agorta.loc');
			}
		}

		$agorta_url=explode('//', $this->f3->get('agorta_url'));
		$this->agorta_scheme=$agorta_url[0].'//';
		$this->web=\Web::instance();
	}

	function uniqcashbox($store, $rm) {
		$vars=array(
			'token'=>$this->api_pass,
			'store'=>$store,
			'rm'=>$rm
		);
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/uniqcashbox?'.http_build_query($vars);
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Получаем методы оплаты
	function paymentmethods() {
		$options = array(
			'method' => 'POST',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/paymentmethods?token='.$this->api_pass;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$res=json_decode($json['body'], true);
			if($res['success']) {
				foreach($res['paymentmethods'] as $n=>$p){
					if($p['cash']==0) {
						$res['paymentmethods'][$n]['title']='Безналичные';
					}
				}
			}

			return $res;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Получаем пользователей
	function users() {
		$vars=array(
			'token'=>$this->api_pass,
			'store'=>$this->api_store_id
		);
		$options = array(
			'method' => 'POST',
			'content' => http_build_query($vars),
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/users';
		$json=$this->web->request($query, $options);
		if(!$json) {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array($options)
			);
		}
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// получаем товары
	function products($time_update) {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/get?token='.$this->api_pass.'&store='.$this->api_store_id.'&limit='.$this->api_count.'&time='.$time_update;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// получаем клиентов
	function partners($time_update) {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/partners?token='.$this->api_pass.'&limit='.$this->api_count.'&time='.$time_update;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Выгружаем чеки
	function tickets($tickets) {
		$vars=array(
			'token'=>$this->api_pass,
			'tickets'=>json_encode($tickets)
		);
		$options = array(
    		'method'  => 'POST',
    		'content' => http_build_query($vars),
    		'follow_location' => 1
		);
		$url=$this->agorta_scheme.$this->api_domen.'/api/tickets';
		$json=$this->web->request($url, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error'])),
				'noupdate'=>true
			);
		}
	}

	// Получаем баланс аккаунта
	function balance() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/balance?token='.$this->api_pass;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Отправляем ошибки синхронизации
	function logs($rm, $data) {
		$vars=array(
			'token'=>$this->api_pass,
			'logs'=>json_encode($data),
			'rm'=>$rm
		);
		$options = array(
    		'method'  => 'POST',
    		'content' => http_build_query($vars),
    		'follow_location' => 1
		);
		$url=$this->agorta_scheme.$this->api_domen.'/api/logs';
		$json=$this->web->request($url, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error'])),
				'noupdate'=>true
			);
		}
	}

	// Получаем СНО
	function sno() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/sno?token='.$this->api_pass;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}


	// Получаем префиксов для весового штрих-кода и штрих-кода карты клиента
	function barcodes_pr() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/barcodes_pr?token='.$this->api_pass;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Поиск интернет-заказов
	function online_order($data) {
		if($data['surname']!=''
			|| $data['name']
			|| $data['number']
			|| $data['email']
			|| $data['phone']) {
			unset($data['dates']);
		}
		$data['store_id']=$this->api_store_id;
		$vars=array(
			'token'=>$this->api_pass,
			'data'=>json_encode($data)
		);
		$options = array(
    		'method'  => 'POST',
    		'content' => http_build_query($vars),
    		'follow_location' => 1
		);
		$url=$this->agorta_scheme.$this->api_domen.'/api/receipts';
		$json=$this->web->request($url, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error'])),
			);
		}
	}

	// Программа лояльности
	function loyalty() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/getloyalty?token='.$this->api_pass.'&store='.$this->api_store_id;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Запрашиваем документы на фискализацию
	function get_remote_receipts($cashbox) {
		$data=array(
			'store_id'=>$this->api_store_id,
			'cashbox'=>$cashbox,
			'add_cashbox'=>-1
		);
		$vars=array(
			'token'=>$this->api_pass,
			'data'=>json_encode($data),
		);
		$options = array(
    		'method'  => 'POST',
    		'content' => http_build_query($vars),
    		'follow_location' => 1
		);
		$url=$this->agorta_scheme.$this->api_domen.'/api/fiscalization';
		$json=$this->web->request($url, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error'])),
			);
		}
	}

	// Получаем рекламу
	function advertising() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1,
    		'timeout'=>1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/advertising?token='.$this->api_pass.'&store='.$this->api_store_id;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Сколько интернет-заказов
	function neworderscount() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		
		$query=$this->agorta_scheme.$this->api_domen.'/api/neworderscount?token='.$this->api_pass.'&store_id='.$this->api_store_id;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Загрузка статусов заказов
	function ordersstatuses() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		
		$query=$this->agorta_scheme.$this->api_domen.'/api/get_ordersstatuses?token='.$this->api_pass;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Изменить статус заказа
	function change_order_status($id, $status_id) {
		$vars=array(
			'token'=>$this->api_pass,
			'orders'=>json_encode(array($id=>$status_id)),
			'user'=>$this->f3->get('authorization_user.name')
		);
		$options = array(
			'method' => 'POST',
    		'follow_location'=>1,
    		'content' => http_build_query($vars)
		);
		
		$query=$this->agorta_scheme.$this->api_domen.'/api/orderstatus';
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	// Запрос новой версии
	function new_version($version) {
		$options = array(
			'method'=>'GET',
    		'follow_location'=>1
		);
		
		$query=$this->f3->get('agorta_url').'/api/update?soft=1&version='.$version;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	function changestop($data) {
		$options = array(
			'method'=>'GET',
    		'follow_location'=>1
		);
		
		$query=$this->agorta_scheme.$this->api_domen.'/api/changestop?token='.$this->api_pass.'&store_id='.$this->api_store_id.'&product_id='.$data['id'].'&stop='.$data['stop'];
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	function clearstop() {
		$options = array(
			'method'=>'GET',
    		'follow_location'=>1
		);
		
		$query=$this->agorta_scheme.$this->api_domen.'/api/clearstop?token='.$this->api_pass.'&store_id='.$this->api_store_id;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	function searchsubdomain($term) {
		$options = array(
			'method'=>'GET',
    		'follow_location'=>1
		);
		
		$query=$this->f3->get('agorta_url').'/api/searchsubdomain?term='.$term;
		$res=$this->web->request($query, $options);
		return $res['body'];
	}

	function gen_license($partners=array()) {
		if(mb_stripos($this->f3->get('SERVER.SERVER_SOFTWARE'), 'ksweb')>0) {
			$partners[]='ksweb';
		}
		if($this->f3->get('neva')===true) {
			$partners[]='neva';
		}
		$vars=array(
			'partners'=>json_encode($partners)
		);
		$options = array(
			'method'=>'POST',
    		'follow_location'=>1,
    		'content'=>http_build_query($vars)
		);
		
		$query=$this->f3->get('agorta_url').'/api/genlicense';
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	function getstores($get) {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$get['url']=str_replace('https://', '', $get['url']);
		$get['url']=str_replace('http://', '', $get['url']);
		$u=explode('.', $get['url']);
		$u=array_reverse($u);
		if($u[0]=='loc') {
			$this->f3->set('agorta_url', 'http://agorta.loc');
		}
		$query=$this->f3->get('agorta_url').'/api/getstores?token='.$get['token'].'&url='.$get['url'];
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	function gen_api_key($data) {
		$options = array(
			'method' => 'POST',
    		'follow_location' => 1,
    		'content'=>http_build_query($data)
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/genapikey';
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	function deliveryaction($url) {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.$url.'&token='.$this->api_pass;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}

	function ping($sets,$receipt=array(), $other_data='') {
		if($sets['partner_id']) {
			$partners=array(
				$sets['partner_id'],
			);
		}
		else {
			$partners=array();
		}
		if(mb_stripos($this->f3->get('SERVER.SERVER_SOFTWARE'), 'ksweb')>0) {
			$partners[]='ksweb';
		}
		if($this->f3->get('neva')===true) {
			$partners[]='neva';
		}
		$vars=array(
			'license'=>$sets['license_key'],
			'domen'=>$sets['domen'],
			'date_end'=>$sets['license_end'],
			'ping'=>$sets['ping'],
			'receipt'=>json_encode($receipt),
			'other_data'=>$other_data,
			'check_end'=>$sets['check_end'],
			'partners'=>json_encode($partners)
		);
		$options = array(
			'method'=>'POST',
    		'follow_location'=>1,
    		'content'=>http_build_query($vars),
    		'timeout'=>3
		);
		
		$query=$this->f3->get('agorta_url').'/api/ping';
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
		
		return array(
			'success'=>false,
			'txt'=>'error'
		);
	}

	function check_end($sets) {
		$vars=array(
			'license'=>$sets['license_key']
		);
		$options = array(
			'method'=>'POST',
    		'follow_location'=>1,
    		'content'=>http_build_query($vars)
		);
		
		$query=$this->f3->get('agorta_url').'/api/checkend';
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
		
		return array(
			'success'=>false,
			'txt'=>'error'
		);
	}

	function partner_id() {
		$options = array(
			'method' => 'GET',
    		'follow_location' => 1
		);
		$query=$this->agorta_scheme.$this->api_domen.'/api/partner_id?token='.$this->api_pass;
		$json=$this->web->request($query, $options);
		if(mb_strpos($json['headers'][0], '200')!==false || mb_strpos($json['headers'][1], '200')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '413')!==false || mb_strpos($json['headers'][1], '413')!==false) {
			$body=json_decode($json['body'], true);
			return $body;
		}
		elseif(mb_strpos($json['headers'][0], '418')!==false || mb_strpos($json['headers'][1], '418')!==false) {
			return array(
				'success'=>418,
				'error'=>array('i_am_teapot'),
				'debug'=>array()
			);
		}
		else {
			return array(
				'success'=>false,
				'error'=>array('error'),
				'debug'=>array_merge($json['request'], $json['headers'], array($json['body'], $json['error']))
			);
		}
	}
}
