<?php
namespace Models;

class inpas {
	public $f3, $sets, $config;

	function __construct($f3, $sets, $config) {
		$this->f3=$f3;
		$this->sets=$sets;
        $this->config=$config;
	}

	function send_cmd($cmd) {
		if(!file_exists($this->config['DualConnectorPath'].$this->config['DualConnectorFile'])) {
			return array (
				'success'=>false,
				'txt'=>'Ошибка. Не найден исполняемый файл'
			);
		}

		if(file_exists($this->config['DualConnectorPath']."result.txt")) {
			unlink($this->config['DualConnectorPath']."result.txt");
		}
		if(file_exists($this->config['DualConnectorPath']."receipt.txt")) {
			unlink($this->config['DualConnectorPath']."receipt.txt");
		}
		
		$cmd .= " -z".$this->config['TerminalID'];
		$cmd=str_replace("\n", '', $cmd);
		$cmd=str_replace("\r", '', $cmd);
		
		exec("\"".$this->config['DualConnectorPath'].$this->config['DualConnectorFile']."\" ".$cmd."\"");
		
		if(!file_exists($this->config['DualConnectorPath']."result.txt")) {
			return array (
				'success'=>false,
				'txt'=>'Ошибка. Не найден файл результатов.'
			);
		}
		
		$cheq='';
		$success = false;
		$status_code = 0;
		$status_txt='';
		$pan='';
		$transid='';
		$authcode='';
		$lines=file($this->config['DualConnectorPath']."result.txt");
		foreach ($lines as $line) {
			$l=explode('=', $line);
			$l[0]=str_replace(' ', '', $l[0]);
			$l[0]=str_replace("'", '', $l[0]);
			$l[0]=trim($l[0]);

			$l[1]=str_replace(' ', '', $l[1]);
			$l[1]=str_replace("'", '', $l[1]);
			$l[1]=trim($l[1]);

			if($l[0]=='[10]') {
				$pan=$l[1];
			}

			if($l[0]=='[13]') {
				$authcode=$l[1];
			}

			if($l[0]=='[14]') {
				$transid=$l[1];
			}
			
			if($l[0]=='[19]') {
				$status_txt=$l[1];
			}

			if($l[0]=='[39]') {
				if((int) $l[1] === 1) {
					$success=true;
				}
				else {
					$status_code=$l[1];
				}
			}
		}
		
		if(file_exists($this->config['DualConnectorPath']."receipt.txt")) {
			$cheq=file_get_contents($this->config['DualConnectorPath']."receipt.txt");
		}
		
		if (!preg_match('//u', $cheq)) {
			$cheq=iconv("windows-1251","utf-8",$cheq);
		}
		$cheq=str_replace('~', '' , $cheq);

		if (!preg_match('//u', $status_txt)) {
			$status_txt=iconv("windows-1251","utf-8",$status_txt);
		}
		
		if($success) {
			$slips=explode('0xDA^^', $cheq);
			$slips[0]=str_replace('0xDF^^', '' , $slips[0]);
			if(!$slips[1]) {
				$slips[1]=$slips[0];
			}
			return array(
				'success'=>true,
				'txt'=>nl2br($slips[0]),
				'slip'=>nl2br($slips[1]),
				'pan'=>$pan,
				'transid'=>$transid,
				'authcode'=>$authcode
			);
		}
		
		return array(
			'success'=>false,
			'txt'=>nl2br($status_txt).'<br>Код статуса: '.$status_code
		);
	}

	function ticket($type, $sum, $return_bt=null) {
		if($type=='sale') {
			$cmd='-o'.$this->config['Sale'];
		}
		elseif($type=='return') {
			$cmd='-o'.$this->config['Return'];
		}
		else {
			$cmd='-o'.$this->config['Cancel'];
		}
		$cmd.=" -a".($sum*100)." -c643";
		if($type!='sale') {
			$cmd.=" -u".$return_bt['authcode']." -r".$return_bt['transid'];
		}
		return $this->send_cmd($cmd);
	}

	function z() {
		$cmd='-o'.$this->config['Close'];
		return $this->send_cmd($cmd);
	}

	function x() {
		$cmd='-o'.$this->config['X'].' -m20';
		return $this->send_cmd($cmd);
	}

	function testconnection() {
		$cmd='-o'.$this->config['Test'].' -a10 -c643';
		return $this->send_cmd($cmd);
	}
}
