<?php
namespace Models;

// Модель для настроек
class Multikassa {
	public $db, $f3;

	public function __construct($db, $f3) {
		$this->db=$db;
		$this->f3=$f3;
	}

	function scan($rm_id, $data) {
		$cashboxes=array();
		foreach ($data as $ip=>$req) {
			$json=json_decode($req, true);
			if(is_array($json) && $json['success']===true && $rm_id!=$json['name']) {
				$cashboxes[$ip]=$json['name'];
			}
		}
		$settings=new \Models\Settings($this->f3, $this->db);
		return $settings->save_base(array('other_cashboxes'=>json_encode($cashboxes)));
	}

	function rooms() {
		$r=new \Models\Rooms($this->db, $this->f3);
		$rooms=$r->select_rooms();
		$t=new \Models\Tables($this->db, $this->f3);
		$tables=$t->select_tables();
		return array(
			'success'=>true,
			'rooms'=>$rooms,
			'tables'=>$tables
		);
	}

	function tables($room) {
		$t=new \Models\Tables($this->db, $this->f3);
		$tables=$t->tables_from_room($room, true);
		return array(
			'success'=>true,
			'tables'=>$tables
		);
	}

	function all_open() {
		$r=new \Models\Receipts($this->db, $this->f3);
		$receipts=$r->all_open();
		return array(
			'success'=>true,
			'receipts'=>$receipts['receipts']
		);
	}

	function all_order_create($kitchen=1, $bar=1, $id_kitchen=0, $id_bar=0) {
		$r=new \Models\Receipts($this->db, $this->f3);
		$receipts=$r->all_order_create($kitchen, $bar, $id_kitchen, $id_bar);
		return array(
			'success'=>true,
			'receipts'=>$receipts
		);
	}

	function all_order_complite($kitchen=1, $bar=1, $id_kitchen=0, $id_bar=0) {
		$r=new \Models\Receipts($this->db, $this->f3);
		$receipts=$r->all_order_complite($kitchen, $bar, $id_kitchen, $id_bar);
		return array(
			'success'=>true,
			'receipts'=>$receipts
		);
	}

	function intercept($id) {
		$receipt=$this->db->exec("SELECT * FROM receipts WHERE id=? LIMIT 1", $id);
		$lines=$this->db->exec("SELECT * FROM receiptlines WHERE receipt_id=?", $id);
		return array(
			'success'=>true,
			'receipt'=>$receipt[0],
			'receiptlines'=>$lines
		);
	}

	function delete_receipt($id) {
		$r=new \Models\Receipts($this->db, $this->f3);
		return $r->delete_receipt($id);
	}
}