<?php
namespace Models;

// Модель для всех контроллеров
class Controller {
	public $f3;

	public function __construct($f3) {
		$this->f3=$f3;
	}

	// получение данных дл подключения к API
	static function get_api_config() {
		if(file_exists('app/api_config.php')) {
			include('app/api_config.php');
			$api_domen=str_replace('http://', '', $api_domen);
			$api_domen=str_replace('https://', '', $api_domen);
			$s=explode('.', $api_domen);
			$subdomen=$s[0];
		}
		else {
			$api_store_id='';
			$api_rm_id='';
			$api_domen='';
			$api_pass='';
			$api_count='';
			$subdomen='';
		}

		return array(
			'store_id'=>$api_store_id,
			'rm_id'=>$api_rm_id,
			'domen'=>$api_domen,
			'pass'=>$api_pass,
			'count'=>$api_count,
			'subdomen'=>$subdomen
		);
	}

	// Создание базы данных
	function create_database($instance, $db_name, $autonomous=null) {
		$api_data=$this->get_api_config(); // получаем данные для API
		// Берем по API даные о пользовательских группах и пользователях
		if(!$api_data['domen'] && !$autonomous) {
			unlink('app/api_config.php');
			return array(
				'success'=>false,
				'txt'=>'not_enough_data',
				'reroute'=>'/settings/api'
			);
		}
		if(!$autonomous) {
			$api=new \Models\Api($this->f3, $api_data['domen'], $api_data['pass'], $api_data['store_id'], $api_data['count']);		
			$data=$api->users();

			if(!$data['success']) {
				$txt='';
				foreach ($data['error'] as $er) {
					$txt.=$er.'<br>';
				}
				return array(
					'success'=>false,
					'txt'=>$txt
				);
			}

			$pays=$api->paymentmethods();

			if(!$pays['success']) {
				$txt='';
				foreach ($pays['error'] as $er) {
					$txt.=$er.'<br>';
				}
				return array(
					'success'=>false,
					'txt'=>$txt
				);
			}

			$sno_api=$api->sno();
			if($sno_api['success']) {
				$sno=$sno_api['sno'];
			}
			else {
				$sno='01';
			}

			$barcodes_pr_api=$api->barcodes_pr();
		}
		else { // Если автономный режим
			$data=$autonomous['users'];
			$data['usergroups']=array(array('id'=>1, 'title'=>'Администраторы', 'module'=>''));
			$pays['paymentmethods']=$autonomous['paymentmethods'];
			$sno=$autonomous['sno'];
			$barcodes_pr_api=$autonomous['barcodes_pr_api'];
		}

		// Если нет папки db, то создаем ее 
		if(!file_exists('db')) {
			mkdir('db', 0777);
			chmod('db', 0777);
		}

		$db=new \DB\SQL('sqlite:'.$db_name);
		$sql=$this->f3->read($instance);
		$sql=str_replace("\r", "", $sql);
		$strs=explode("\n", $sql); // читаем исходник базы построчно
		foreach ($strs as $s) {
			$res+=$db->exec(trim($s)); // Создаем таблицы
		}

		if($res>0) {
			$g=new \Models\Usergroups($db, $this->f3);
			foreach ($data['usergroups'] as $group) {
				$res=$g->save_group($group, 'add');
				if(!$res['success']) {
					break;
				}
			}
			
			if($res['success']) {
				$u=new \Models\Users($db, $this->f3);
				foreach ($data['users'] as $user) {
					$res=$u->save_user($user, 'add');
					if(!$res['success']) {
						break;
					}
				}
			}

			if($res['success']) {
				foreach ($pays['paymentmethods'] as $pay) {
					$pays_type[$pay['id']]=max(abs($pay['cash']-1), 0);
					$r=$db->exec("INSERT INTO paymentmethods (id, title, cash) VALUES (?, ?, ?)", array($pay['id'], $pay['title'], $pay['cash']));
					if(!$r) {
						$res['success']=false;
						break;
					}
					else {
						$res['success']=true;
					}
				}
				$db->exec("UPDATE fr_settings SET rm=?, pays_type=?, sno=?", array((string)$api_data['rm_id'], json_encode($pays_type), $sno));
				$db->exec("UPDATE cd_settings SET rm=?", array((string)$api_data['rm_id']));
				$db->exec("UPDATE scales_settings SET rm=?", array((string)$api_data['rm_id']));

				
				if($barcodes_pr_api['barcodes_pr']) {
					$sql=array();
					$val=array();
					foreach ($barcodes_pr_api['barcodes_pr'] as $name => $value) {
						$sql[]="INSERT OR REPLACE INTO settings (name, value) VALUES (?, ?)";
						$val[]=array($name, $value);
					}
					$db->exec($sql, $val);
				}
				$random_str='АБВГДЕЖЗИКЛМНОПРСТУФХЧШЫЫЫЭЮЯ';
				$db->exec("INSERT INTO settings ('name', 'value') VALUES ('orders_prefix', ?)", mb_substr($random_str, rand(0, mb_strlen($random_str)-1), 1));
			}

			if($autonomous) {
				$db->exec("UPDATE synchronization SET auto_sinch=?", -1);
				$db->exec("INSERT OR REPLACE INTO settings (name, value) VALUES (?, ?), (?, ?), (?, ?), (?, ?), (?, ?)", array('autonomous', 1, 'license_key', $autonomous['license']['license_key'], 'ping', 0, 'license_end', 0, 'partner_id', $autonomous['partner_id']));
				$db->exec("INSERT INTO productcategories (id, title, parent_id, date_delete, date_update) VALUES (1, 'Без категории', 0, 0, ?)", microtime(true));
			}
			else {
				$partner_id=$api->partner_id();
				if($partner_id['success']) {
					$db->exec("INSERT OR REPLACE INTO settings (name, value) VALUES (?, ?)", array('partner_id', $partner_id['partner_id']));
				}
			}
		}

		if($res['success']) {
			return array(
				'success'=>true,
				'db'=>$db
			);
		}
		else {
			unset($db);
			unlink($this->f3->get('ROOT').'/'.$db_name); // удаляем файл базы, если не удалось выполнить запросы
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
	}

	// Проверка доступа к разделу
	function access() {
		$user=$this->f3->get('authorization_user');
		$page=$this->f3->get('PARAMS.model').'/'.$this->f3->get('PARAMS.method');
		if($page=='receipts/discount' && in_array('receipts/select_discount', $user['module'])) {
			$user['module'][]='receipts/discount';
		}
		if(($user['module'] && in_array($page, $user['module'])) || (($user && !$user['module'])) || !file_exists($this->f3->get('db_name')) ) {
			return array('success'=>true);
		}

		return array(
			'success'=>false,
			'txt'=>'access_closed'
		);
	}

	// Главное меню
	function get_main_menu($sets=array()) {
		$module=$this->f3->get('authorization_user.module');
		if(!isset($module)) return;
		$menu_array=array(
			'receipts/sales'=>array('title'=>'Продажа', 'class'=>''),
			'receipts/fiscalization'=>array('title'=>'Фискализировать удаленно <span id="remote_receipts_n"></span>', 'class'=>'send_ajax remote_receipts'),
			'receipts/return'=>array('title'=>'Возврат', 'class'=>''),
			'receipts/search'=>array('title'=>'Чеки', 'class'=>''),
			'receipts/cashin'=>array('title'=>'Внесение', 'class'=>''),
			'receipts/cashout'=>array('title'=>'Изъятие', 'class'=>''),
			'receipts/pricetags'=>array('title'=>'Печать ценников и готовых наборов', 'class'=>''),
			'linesset/list'=>array('title'=>'Готовые наборы', 'class'=>''),
			'products/stoplist'=>array('title'=>'Стоп-лист', 'class'=>''),
			'egais/main'=>array('title'=>'ЕГАИС', 'class'=>''),
			'receipts/reports'=>array('title'=>'Смены и отчеты', 'class'=>'')
		);

		$module=$this->f3->get('authorization_user.module');

		$menu=array();
		foreach ($menu_array as $path => $array) {
			if(in_array($path, $module)) {
				$menu['/'.$path]=$array;
			}
		}

		$settings_array=array(
			'settings/base'=>array('title'=>'Настройки программы', 'class'=>''),
			'settings/marking'=>array('title'=>'Маркированные товары и ЕГАИС', 'class'=>''),
			'settings/api'=>array('title'=>'API', 'class'=>''),
			'settings/autonomous'=>array('title'=>'Настройки для автономного режима', 'class'=>''),
			'settings/devices'=>array('title'=>'Настройки оборудования', 'class'=>''),
			'settings/rooms'=>array('title'=>'Залы', 'class'=>''),
			'settings/synchronization'=>array('title'=>'Синхронизация', 'class'=>''),
			'settings/logs'=>array('title'=>'Ошибки <span id="logs_n"></span>', 'class'=>''),
			'settings/reset_ticket'=>array('title'=>'Аннулирование чека', 'class'=>'show_window'),
			'settings/continue_print'=>array('title'=>'Продолжить печать', 'class'=>'show_window'),
			'settings/service'=>array('title'=>'Сервисное обслуживание', 'class'=>'')
		);

		$settings=array();
		if($sets['autonomous']) {
			$settings['/productcategories/directory']=array('title'=>'Категории номенклатуры', 'class'=>'');
			$settings['/products/directory']=array('title'=>'Номенклатура', 'class'=>'');
			$settings['/usergroups/directory']=array('title'=>'Группы пользователей', 'class'=>'');
			$settings['/users/directory']=array('title'=>'Пользователи', 'class'=>'');
		}
		if(!$sets['cafe_mode']) {
			unset($settings_array['settings/rooms']);
		}
		foreach ($settings_array as $path => $array) {
			if(in_array($path, $module)) {
				$settings['/'.$path]=$array;
			}
		}

		if($sets['autonomous']) {
			$settings['/settings/license']=array('title'=>'Лицензия', 'class'=>'');
		}

		$receipts_array=array(
			'receipts/new'=>array('title'=>'Открыть новый чек', 'class'=>'send_ajax'),
			'receipts/move'=>array('title'=>'Переместить на другой стол', 'class'=>'show_window'),
			'receipts/split'=>array('title'=>'Разделить чек', 'class'=>'show_window'),
			'receipts/all_open'=>array('title'=>'Показать все открытые чеки', 'class'=>'show_window')
		);
		$receipts=array();
		foreach ($receipts_array as $path => $array) {
			if(in_array($path, $module)) {
				$receipts['/'.$path]=$array;
			}
		}

		if(!$sets['egais']) {
			unset(
				$menu['/egais/main']
			);
			$egais_menu=array();
		}
		else {
			$egais_menu=array(
				'egais/main'=>array('title'=>'Входящие документы', 'class'=>''),
				'egais/writeoff'=>array('title'=>'Списание', 'class'=>''),
				'egais/writeoff_repeal'=>array('title'=>'Отменить списание', 'class'=>''),
				'egais/beer_currentstock'=>array('title'=>'Актуализировать остатки пива', 'class'=>''),
				'egais/createttn'=>array('title'=>'Накладная', 'class'=>''),
				'egais/utminfo'=>array('title'=>'Служебная инфорамция', 'class'=>'show_window'),
				'egais/rests'=>array('title'=>'Запрос остатков на складе', 'class'=>'show_window'),
				'egais/nattn'=>array('title'=>'Запрос необработанных накладных', 'class'=>'show_window'),
				'egais/declaration'=>array('title'=>'Алкодекларации', 'class'=>''),
			);
		}

		return array(
			'menu'=>$menu,
			'settings'=>$settings,
			'receipts'=>$receipts,
			'egais'=>$egais_menu
		);
	}

	function get_neva($db) {
		$res=$db->exec("SELECT * FROM fr_settings WHERE printer='kkm' AND active='1' LIMIT 1");
		if($res[0]['driver']=='drivers/printers/php_neva_ffd105' || $res[0]['driver']=='drivers/printers/php_neva_ffd12') {
			return true;
		}
		return false;
	}
}
