<?php
namespace Controllers;
// Контроллер Пользователи
class Users extends Controller {
	public $groups;

	public function __construct() {
		parent::__construct();
		//$this->groups=new \Models\Usergroups($this->db, $this->f3); // модель пользовательских групп
		$this->groups=$this->users->groups;
	}

	// Страница авторизации
	function autorization() {
		if($this->users->is_login()) {
			$this->f3->reroute('/'); // Если пользователь авторизован, то перекинем его на главную
		}
		$this->f3->clear('authorization_user');
		if(!$this->cd) {
			$this->cd=new \Models\Cd($this->db, $this->f3);
		}
		$this->cd->close_txt();
		$this->f3->set('users', $this->users->select_users()); // Список пользователей
		$this->f3->set('page_data', $this->users->page_data('autorization')); // Берем данные для страницы
	}

	// Авторизация пользователя
	function post_autorization() {
		$post=$this->f3->get('POST');
		$res=$this->users->user_autorization($post); // пытаемся авторизоваться
		$res['txt']=$this->messages->message($res['txt'])['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	// Запрос на подтверждение авторизации, когда уже под учетной записью кто-то авторизован
	function autorization_continue() {
		$this->f3->set('page_data', $this->users->page_data('autorization_continue')); // Берем данные для страницы
	}

	// Выход
	function logout() {
		$res=$this->users->logout();
		$mess=$this->messages->message($res['txt']);
		$res['txt']=$mess['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}

	function directory() {
		$users=$this->users->select_users(null, array('order'=>'name'));
		$this->f3->set('data', $users);
		$this->f3->set('page_data', $this->users->page_data('directory'));
	}

	function form() {
		$id=$this->f3->get('GET.id');
		$data=array();
		$inc='add';
		if($id>0) {
			$data=$this->users->select_users(array('u.id=?', $id), array('limit'=>1));
			if(!$data) {
				$this->f3->set('page_data', $this->messages->message('not_found'));
				return;
			}
			$inc='change';
			$name=explode(' ', $data[0]['name']);
			$data[0]['surname']=$name[0];
			$data[0]['name']=$name[1];
			$data[0]['second_name']=$name[2];
		}
		$groups=$this->groups->select_groups();
		$this->f3->set('groups', $groups);
		$this->f3->set('data', $data[0]);
		$this->f3->set('page_data', $this->users->page_data($inc));
	}

	function post_form() {
		$post=$this->f3->get('POST');
		if($post['id'])$action='change';
		else $action='add';
		$res=$this->users->save_user($post, $action);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	function delete() {
		$id=$this->f3->get('GET.id');
		$res=$this->users->delete($id);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	function kiosklogout() {
		$this->f3->set('page_data', $this->users->page_data('kiosklogout'));
	}

	function post_kiosklogout() {
		$user=$this->f3->get('authorization_user');
		if($user['pass']!=$this->f3->get('POST.user_pass')) {
			$res=array(
				'success'=>false,
				'txt'=>'pass_incorrect'
			);
		}
		else {
			$res=$this->users->logout();
		}
		$mess=$this->messages->message($res['txt']);
		$res['txt']=$mess['txt']; // получаем текст ответа
		echo json_encode($res); // сообщаем что вышло
		exit();
	}
}
