<?php
namespace Controllers;

// Контроллер для совместной работы нескольких касс
class Multikassa extends Controller {

	public function __construct() {
		parent::__construct();
		$this->model=new \Models\Multikassa($this->db, $this->f3); // модель залов
	}

	// Поиск подлюченных касс
	function scan() {
		$res=$this->multi_curl_range($this->sets['ip_range_start'], $this->sets['ip_range_end'], '/multikassa/test', $this->sets['ip_port']);
		$res=$this->model->scan($this->api_data['rm_id'], $res);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	// Подтверджение, что касса работает
	function test() {
		if($this->sets['multikassa']==1) {
			$success=true;
		}
		else {
			$success=false;
		}
		echo json_encode(array('success'=>$success, 'name'=>$this->api_data['rm_id']));
		exit();
	}

	// Отдаем залы и столы
	function rooms() {
		echo json_encode($this->model->rooms());
		exit();
	}

	// Отдаем столы для выбора чека
	function tables() {
		$room=$this->f3->get('GET.room');
		echo json_encode($this->model->tables($room));
		exit();
	}

	// Все открытые чеки
	function all_open() {
		echo json_encode($this->model->all_open());
		exit();
	}

	// Все чеки в работе
	function all_order_create() {
		$get=$this->f3->get('GET');
		if(!isset($get['kitchen'])) $get['kitchen']=1;
		if(!isset($get['bar'])) $get['bar']=1;
		if(!isset($get['id_kitchen'])) $get['id_kitchen']=0;
		if(!isset($get['id_bar'])) $get['id_bar']=0;
		echo json_encode($this->model->all_order_create($get['kitchen'], $get['bar']));
		exit();
	}

	// Все чеки на выдачу
	function all_order_complite() {
		$get=$this->f3->get('GET');
		if(!isset($get['kitchen'])) $get['kitchen']=1;
		if(!isset($get['bar'])) $get['bar']=1;
		echo json_encode($this->model->all_order_complite($get['kitchen'], $get['bar']));
		exit();
	}

	// Перехват чека
	function intercept() {
		$id=$this->f3->get('GET.id');
		echo json_encode($this->model->intercept($id));
		exit();
	}

	// Удаление чека
	function delete_receipt() {
		$id=$this->f3->get('GET.id');
		echo json_encode($this->model->delete_receipt($id));
		exit();
	}
}