<?php
namespace Models;

// Модель Столов
class Tables extends \DB\SQL\Mapper {
	public $db, $f3;

	public function __construct($db, $f3) {
		parent::__construct($db, 'tables' ); // подключаемся к таблице
		$this->db=$db;
		$this->f3=$f3;
	}

	// Информация об открываемой странице
	function page_data($page='sales') {
		$pages=array(
			'add'=>array(
				'title'=>'Добавить стол',
				'inc'=>'tables_form.htm'
			),
			'change'=>array(
				'title'=>'Редактировать стол',
				'inc'=>'tables_form.htm'
			)
		);
		$pages[$page]['page']=$page;
		return $pages[$page];
	}

	// Выбор из базы
	function select_tables($query=null, $options=null) {
		$this->reset();
		$this->load($query, $options);
		$tables=array();
		if(!$this->dry()) {
			do {
				$tables[]=$this->cast();
			}
			while ($this->skip());
		}
		return $tables;
	}

	// Выбор столов для зала, по координатам
	function tables_from_room($room, $receipts_count=false) {
		$tables=array();
		$res=$this->select_tables(array('room=?', $room));
		if($receipts_count) {
			$receipts=new \Models\Receipts($this->db, $this->f3);
		}
		if(!empty($res)) {
			foreach ($res as $r) {
				if($receipts_count) {
					//$receipts->reset();
					//$r['receipts_count']=$receipts->count(array('time=0 AND table_id=?', $r['id']));
					$r_c=$receipts->get_not_empty_for_table($r['id']);
					if(is_array($r_c))$r['receipts_count']=count($r_c);
					else $r['receipts_count']=0;
				}
				$tables[$r['x']][$r['y']]=$r;
			}
		}
		return $tables;
	}

	// Сохраняем стол
	function save_table($data) {
		$this->reset();
		$this->load(array('room=? AND x=? AND y=? AND id!=?', array($data['room'], $data['x'], $data['y'], $data['id'])), array('limit'=>1));
		if(!$this->dry()) {
			return array(
				'success'=>false,
				'txt'=>'place_taken'
			);
		}
		$this->reset();
		$this->load(array('room=? AND title=? AND id!=?', array($data['room'], $data['title'], $data['id'])), array('limit'=>1));
		if(!$this->dry()) {
			return array(
				'success'=>false,
				'txt'=>'table_is_exists'
			);
		}
		$this->reset();
		$delete_table=array();
		if($data['id']) {
			$this->load(array('id=?', $data['id']), array('limit'=>1));
			if(!$this->dry()) {
				$delete_table=$this->cast();
				$delete_table['title']=str_replace('\\', '\\\\', $delete_table['title']);
			}
		}
		else {
			unset($data['id']);
		}
		$this->copyFrom($data);
		if($this->save()) {
			if(!$data['id']) $data['id']=$this->get('_id');
			$data['title']=str_replace('\\', '\\\\', $data['title']);
			return array(
				'success'=>true,
				'txt'=>'save_successful',
				'close_all_window'=>true,
				'function'=>'delete_table(\''.json_encode($delete_table).'\'); add_table(\''.json_encode($data).'\')'
			);
		}
		else {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
	}

	// Удаление стола
	function delete($id) {
		// Проверяем наличие стола
		$this->reset();
		$this->load(array('id=?', $id), array('limit'=>1));
		if($this->dry()) {
			return array(
				'success'=>false,
				'txt'=>'not_found'
			);
		}
		$r=new \Models\Receipts($this->db, $this->f3);
		$r->load(array('time=0 AND table_id=?', $id), array('limit'=>1));
		if(!$r->dry()) {
			return array(
				'success'=>false,
				'txt'=>'table_is_not_empty'
			);
		}
		$data=$this->cast();
		if($this->erase()) {
			return array(
				'success'=>true,
				'txt'=>'delete_successful',
				'close_all_window'=>true,
				'function'=>'delete_table(\''.json_encode($data).'\')'
			);
		}
		else {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
	}

	function other_tables_from_room($data, $tables) {
		foreach ($data as $res) {
			$json=json_decode($res, true);
			if($json['success']) {
				foreach ($json['tables'] as $value) {
					foreach ($value as $table) {
						if($tables[$table['x']][$table['y']]) {
							$table['receipts_count']+=$tables[$table['x']][$table['y']]['receipts_count'];
						}
						$tables[$table['x']][$table['y']]=$table;
					}
				}
			}
		}
		return $tables;
	}
}
