<?php
namespace Models;

// Модель способов оплаты
class Paymentmethods extends \DB\SQL\Mapper {
	public $db, $f3;

	public function __construct($db, $f3) {
		parent::__construct($db, 'paymentmethods' ); // подключаемся к таблице способов оплаты
		$this->db=$db;
		$this->f3=$f3;
	}

	// Выборка методов оплаты
	function select_method($query=null, $options=null) {
		if(!$query) {
			$query=array('id>?', 0); // чтобы хоть что-то вставить в фильтры
		}

		// формируем сортировку и лимиты
		if(!$options) {
			$options=array('order'=>'id'); // Сортировка по умолчанию
		}
		// собственно сам запрос
		$methods=array();
		$this->load($query, $options);
		do {
			$methods[]=$this->cast();
		}
		while($this->skip());
		$this->reset();
		return $methods;
	}

	// Считаем наличность по чекам
	function cash_in_box($report) {
		$pays=$this->select_method();
		$total=0;
		if(!$report) return $total;
		foreach ($report as $type => $r) {
			foreach ($pays as $p) {
				if($p['cash']==1) {
					if($type==$this->f3->get('receipt_return'))$total-=$r['pay'][$p['id']];
					else $total+=$r['pay'][$p['id']];
				}
			}
		}
		return round($total, 2);
	}
}
