<?php
namespace Models;

// Модель клиентов
class Partners extends \DB\SQL\Mapper {
	public $db, $f3;

	public function __construct($db, $f3) {
		parent::__construct($db, 'partners' ); // подключаемся к таблице клиентов
		$this->db=$db;
		$this->f3=$f3;
	}

	function page_data($page='search') {
		$pages=array(
			'search'=>array(
				'title'=>'Поиск клиентов',
				'inc'=>'partners_search.htm'
			),
			'search_result'=>array(
				'title'=>'Результат поиска клиентов',
				'inc'=>'partners_search_result.htm'
			),
			'not_found'=>array(
				'title'=>'Клиент не найден',
				'inc'=>'partners_not_found.htm'
			)
		);
		$pages[$page]['page']=$page;
		return $pages[$page];
	}

	// Выбор из базы
	function select_partner($query=null, $options=null) {
		$partners=array();
		$this->reset();
		$this->load($query, $options);
		if($this->dry()) {
			return $partners;
		}
		do {
			$partners[]=$this->cast();
		}
		while($this->skip());
		return $partners;
	}

	// Обработка номера телефона
	function validate_phone($phone) {
		$phone=preg_replace('~[^0-9]~','',$phone);
		$l=mb_strlen($phone);
		$first=mb_substr($phone, 0, 1);
		if($first=='8') {
			$phone='7'.mb_substr($phone, 1);
		}
		elseif($first=='9') {
			$phone='7'.$phone;
		}
		return $phone;
	}

	// Формирование запроса для поиска
	function validate_q($q) {
		$q=preg_replace('~[^0-9]~','',$q);
		$l=mb_strlen($q);
		if($l==0) {
			$q=-1;
		}
		if($l<13) {
			$order='phone';
			if($l==11) {
				if(mb_substr($q, 0, 1)=='8') {
					$q='7'.mb_substr($q, 1);
				}
				$sql='phone=?';
				$val=$q;
			}
			else {
				$sql.='phone LIKE ?';
				$val='%'.$q.'%';
			}
		}
		else {
			$order='card';
			$sql='card=?';
			$val=$q;
		}
		return array(
			'sql'=>$sql,
			'val'=>$val,
			'order'=>$order
		);
	}

	function partners_bonus($partner, $lines, $sum) {
		$bonus=0;
		foreach ($lines as $l) {
			if($l['add_bonus']>0) {
				$bonus+=$l['add_bonus']*$l['count'];
				$sum-=($l['price']+($l['price']/100*(max($l['vat_type'], 0)*$l['vat']))*$l['count']);
			}
		}

		if($partner['loyalty_type']==2) {
			if($partner['bonus_type']==1) {
				$bonus+=$sum/100*$partner['bonus_discount'];
			}
			elseif($partner['bonus_type']==2) {
				$bonus+=floor($sum/$partner['bonus_summ'])*$partner['bonus_bonus'];
			}
		}
		return $bonus;
	}

	function save_partner($data) {
		$this->reset();
		$this->load(array('partner_id=?', $data['partner_id']), array('limit'=>1));
		$this->copyFrom($data);
		if($this->save()==false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful'
		);
	}
}
