<?php
namespace Models;

// Модель Программ лояльности
class Loyalty extends \DB\SQL\Mapper {
	public $db, $f3;

	public function __construct($db, $f3) {
		parent::__construct($db, 'loyalty' ); // подключаемся к таблице
		$this->db=$db;
		$this->f3=$f3;
	}

	// Выбор из базы
	function select_loyalty($query=null, $options=null) {
		$this->reset();
		$this->load($query, $options);
		$loyalty=array();
		if(!$this->dry()) {
			do {
				$loyalty[]=$this->cast();
			}
			while ($this->skip());
		}
		return $loyalty;
	}

	// Подбор программмы лояльности для добавленного товара
	function get_loyalty($client, $product) {
		$now=time(); // Время сейчас
		$w=date('w'); // Номер дня недели
		$h=sprintf("%'.02d", date('H')); // Час
		if($w==0)$w=7;
		$sql="SELECT * FROM `loyalty` WHERE `date_start`<=? AND `date_end`>=?";
		$val=array(
			$now,
			$now-3600*24
		);
		$loyalty=$this->db->exec($sql, $val);
		$result=array();
		if($loyalty) {
			$group_id=0;
			if($client>0) {
				$partner=$this->db->exec("SELECT group_id FROM partners WHERE partner_id=? LIMIT 1", $client);
				if($partner) {
					$group_id=$partner[0]['group_id'];
				}
			}
			foreach ($loyalty as $n => $l) {
				$ok=false;
				$groups=json_decode($l['partnergroup'], true);
				$hours=json_decode($l['d'.$w], true);
				$data=json_decode($l['data'], true);
				if((!in_array($group_id, $groups) && $groups) || (int)$hours[$h]!=1) {
					continue;
				}

				if($l['action_type']>0) {
					if(isset($data['product'][$product['id']]) || isset($data['category'][$product['category_id']])) {
						$ok=true;
					}
				}
				elseif($l['action_type']<0) {
					if(!isset($data['product'][$product['id']]) && !isset($data['category'][$product['category_id']])) {
						$ok=true;
					}
				}

				if($ok===true) {
					$l['items']=$data;
					$result[$l['id']]=$l;
				}
			}
		}
		return $result;
	}

	// Список скидок
	function select_discounts($discount=false) {
		$where='';
		$val=array();
		if($discount!==false) {
			$where='WHERE value=?';
			$val[]=$discount;
		}
		return $this->db->exec("SELECT * FROM discounts ".$where." ORDER BY value", $val);
	}
}
