<?php
namespace Models;

// Модель для работы с дисплеем покупателя
class Cd extends \DB\SQL\Mapper{
	public $cd, $db, $f3, $sets, $method='POST', $messages, $api_data;

	public function __construct($db, $f3) {
		$this->api_data=$f3->get('api_data');
		if($f3->get('GET.cd_unset')) {
			$sql="UPDATE cd_settings SET active=0 WHERE rm=?";
			$db->exec($sql, $this->api_data['rm_id']);
			return;
		}
		parent::__construct($db, 'cd_settings' ); // подключаемся к таблице с настройками
		$this->f3=$f3;
		$this->db=$db;
		$this->messages=new \Models\Messages();
		$this->sets=$this->get_cd();
		if($this->sets['active']==1 && $this->sets['driver']!='') {
			if(file_exists($this->sets['driver'].'/server.py')) {
				$this->cd=new Cd_python($f3, $this->sets);
			}
			elseif(file_exists($this->sets['driver'].'/server.php')) {
				require_once($this->sets['driver'].'/server.php');
				$this->cd=new Cd_php($f3, $this->sets);
			}
		}
	}

	// Информация об открываемой странице
	function page_data($page='receipt') {
		$pages=array(
			'receipt'=>array(
				'title'=>'Открытый чек',
				'inc'=>'cd_receipt.htm'
			),
			'pricechecker'=>array(
				'title'=>'Информация о товаре',
				'inc'=>'cd_pricechecker.htm'
			)
		);
		$pages[$page]['page']=$page;
		return $pages[$page];
	}

	// Узнаем настройки дисплея покупателя
	function get_cd() {
		$this->reset();
		$this->load(array("rm=?", $this->api_data['rm_id']), array('limit'=>1));
		$sets=$this->cast();
		if(!$sets['driver']) $sets['active']=0;
		return $sets;
	}

	// Сохраняем настройки дисплея покупателя
	function save_cd($post) {
		$this->reset();
		$this->get_cd();
		if(!$post['rm']) {
			$post['rm']=$this->api_data['rm_id'];
		}
		$this->copyFrom($post);
		if($this->save()===false) {
			return array(
				'success'=>false,
				'txt'=>'db_error'
			);
		}
		return array(
			'success'=>true,
			'txt'=>'save_successful'
		);
	}

	// Печать на дисплее покупателя
	function print($txt, $timeout=30) {
		if(!$this->sets['active']) return;
		$this->cd->print($txt, $timeout);
	}

	// Очистить дисплей покупателя
	function clear_cd() {
		$this->print("p;;;");
	}

	// Текст закрытой кассы
	function close_txt() {
		$this->clear_cd();
		$this->print($this->sets['close_txt']);
	}

	// Текст готовности к новой продаже
	function seller_txt() {
		$this->clear_cd();
		$this->print($this->sets['seller_txt']);
	}

	// Текст добавления товара в чек
	function print_line($line, $count) {
		$this->clear_cd();
		$price=$line['price']+($line['price']*($line['vat']/100))*max(0, $line['vat_type']);
		$txt="p;".$line['product_title'].";";
		$txt.=$count."x".number_format($price, 2, '.', '')."=".number_format($price*$count, 2, '.', '').";";
		$this->print($txt);
	}

	// Текст при оплате чека
	function total_price($sum=0, $pay=0) {
		$this->clear_cd();
		$txt="p;Итого:".number_format($sum, 2, '.', '').";";
		if(is_numeric($sum) && !is_numeric($pay) && $pay-$sum>0) {
			$txt.="Сдача:".number_format($pay-$sum, 2, '.', '');
		}
		$txt.=";";
		$this->print($txt);
	}

	// Список драйверов
	function get_drivers() {
		$drivers=array();
		$displays_dir=$this->f3->get('displays_dir');
		$dirs=scandir($displays_dir); // Ищем все драйвера
		if($dirs) {
			foreach ($dirs as $d) {
				$folder=$displays_dir.$d;
				$file=$folder.'/server.config';
				if(is_dir($folder) && file_exists($file)) {
					$config=parse_ini_file($file);
					if($config) {
						$drivers[$folder]=array(
							'title'=>$config['ServerName'],
							'path'=>$folder
						);
					}
				}
			}
		}

		return $drivers;
	}
}
