<?php
namespace Controllers;
// Контроллер Залы
class Rooms extends Controller {

	public function __construct() {
		parent::__construct();
		$this->model=new \Models\Rooms($this->db, $this->f3); // модель залов
	}

	// Страница создания зала
	function add() {
		$inc='add';
		$id=$this->f3->get('GET.id');
		$room=array();
		if($id) {
			$room=$this->model->select_rooms(array('id=?', $id), array('limit'=>1));
			if(!empty($room)) {
				$inc='change';
			}
		}
		$this->f3->set('room', $room[0]);
		$this->f3->set('page_data', $this->model->page_data($inc));
	}
	
	// Сохранение зала
	function post_add() {
		$post=$this->f3->get('POST');
		$res=$this->model->save_room($post);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	// Удаление зала
	function delete() {
		$id=$this->f3->get('GET.id');
		$res=$this->model->delete($id);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	// Страница выбора столов для чеков
	function select_table() {
		$id=$this->f3->get('GET.room_id');
		if(!$id) {
			$id=$this->f3->get('COOKIE.room_id');
		}
		$rooms=$this->model->select_rooms();
		$room=$rooms[0];
		$tables=array();
		if($id) {
			// Находим выбранный зал
			foreach ($rooms as $r) {
				if($r['id']==$id) {
					$room=$r;
					break;
				}
			}
		}
		if(!empty($room)) {
			// Если зал выбран, то находим столы
			$t=new \Models\Tables($this->db, $this->f3);
			$tables=$t->tables_from_room($room['id'], true);
			if($this->sets['multikassa']) {
				$res=$this->multi_curl($this->sets['other_cashboxes_ip'], '/multikassa/tables?room='.$room['id'], $this->sets['ip_port']);
				$tables=$t->other_tables_from_room($res, $tables);
			}
		}
		$this->f3->set('room', $room);
		$this->f3->set('tables', $tables);
		$this->f3->set('rooms', $rooms);
		$this->f3->set('page_data', $this->model->page_data('select_table'));
	}

	// Синхронизация залов и столов с другими кассами в режиме совместной работы
	function synchronization() {
		// Отображаем другие подключенные кассы
		if(!$this->sets['other_cashboxes']) {
			if(!$this->f3->get('GET.attempts')) {
				$res=$this->multi_curl_range($this->sets['ip_range_start'], $this->sets['ip_range_end'], '/multikassa/test', $this->sets['ip_port']);
				$multikassa=new \Models\Multikassa($this->db, $this->f3);
				$multikassa->scan($this->api_data['rm_id'], $res);
				$this->f3->set('attempts', 1);
				$this->f3->reroute('/rooms/synchronization?attempts=1');
			}
			$this->f3->set('page_data', $this->messages->message('error'));
		}
		$this->f3->set('cashboxes', $this->sets['other_cashboxes']);
		$this->f3->set('page_data', $this->model->page_data('select_cashbox'));
	}

	// Синхронизируем залы и столы
	function post_synchronization() {
		$ip=$this->f3->get('POST.ip');
		$res=$this->model->synchronization($ip);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}
}
