<?php
namespace Controllers;
// Контроллер для товаров
class Products extends Controller {

	public function __construct() {
		parent::__construct();
		$this->model=new \Models\Products($this->db, $this->f3);
	}

	function data_matrix($mark) {
		if($this->sets['gs1_symbols']!='') {
        	$mark=str_replace($this->sets['gs1_symbols'], '', $mark);
        }
		$data_matrix=false;
		$result='';
		$part21=explode('-', $mark);
        $len=mb_strlen($mark);
        if(($len==8 || $len==13 || $len==14) && ctype_digit($mark)) {
            $result=$mark;
        }
        elseif($len!=8
            && $len!=13
            && $len!=14
            && preg_match("/[A-Za-z0-9\/\\!”%&’()*+-.,:;=<>?]/", $mark)
            && mb_substr($mark, 0, 2)=='01'
            && mb_substr($mark, 16, 2)=='21') {
            $part=explode('', $mark);
            if(count($part)==1) {
                $part=explode('\u001d', $mark);
            }
            $result=ltrim(mb_substr($part[0], 3, 13), '0');
            $data_matrix=true;
        }
        elseif($len==29
            && preg_match('/^[0-9a-zA-Z!”%&’()*+-.,:;=<>?]+$/' , $mark)
            && ctype_digit(mb_substr($mark, 0, 14))
            && mb_substr($mark, 0, 2)!='01') {
            $result=ltrim(mb_substr($mark, 1, 13), '0');
            $data_matrix=true;
        }
        elseif($len==21
            && count($part21)==3
            && ctype_alnum($part21[0])
            && ctype_digit($part21[1])
            && ctype_alnum($part21[2])) {
            $result=$mark;
        }
        elseif($len==68 && preg_match('/^[0-9A-Z]+$/' , $mark) && mb_substr($mark, 0, 2)!='01') {
            $result=mb_substr($mark, 8, 23);
            $data_matrix=true;
        }
        elseif($len==150 && preg_match('/^[0-9A-Z]+$/' , $mark) && mb_substr($mark, 0, 2)!='01') {
            $result=mb_substr($mark, 1, 13);
            $data_matrix=true;
        }
        else {
            $result=$mark;
        }
		return array(
			'data_matrix'=>$data_matrix,
			'code'=>$result,
			'term'=>$mark
		);
	}

	// Поиск по штрих-коду
	function search_barcodes() {
		$term=$this->f3->get('GET.product_search');

		// Проверяем принадлежность штри-кода к набору товаров
		$pr=mb_substr($term, 0, 2);
		$term_len=mb_strlen($term);
		if($pr==$this->f3->get('linesset_pr') && $term_len==13) {
			$lsm=new \Models\Linesset($this->db, $this->f3);
			$linesset=$lsm->select_linesset(array('barcode=?', $term), array('limit'=>1));
			if($linesset) {
				$term=$linesset[0]['txt'];
			}
		}

		$json=json_decode($term, true);
		if(is_array($json)) {
			$res=$this->model->add_lineset($json);
			echo json_encode($res);
			exit();
		}

		$parent_id=$this->f3->get('GET.parent_id');
		$count=$this->f3->get('GET.coeff');
		
		$not_add=$this->f3->get('GET.not_add');
		$this->f3->set('not_add', $not_add);
		
		$exact_match=$this->f3->get('GET.exact_match');
		$this->f3->set('exact_match', $exact_match);
		
		$in_stock=$this->f3->get('GET.in_stock');
		$this->f3->set('in_stock', $in_stock);
		if($parent_id>0) {
			$res=$this->model->select_product(array('p.date_delete=0 AND p.parent_id=?', $parent_id));
			if($res) {
				$res=array(
					'success'=>true,
					'products'=>$res
				);
			}
		}
		else {
			if(!$term) {
				$this->f3->set('page_data', $this->messages->message('not_enough_data'));
				return;
			}

			$page=$this->f3->get('GET.page');
			if(!$page) $page=1;

			$s=new \Models\Settings($this->f3, $this->db);
			$sets=$s->get_settings(array('weight_code_pr', 'card_code_pr', 'worker_code_pr'));
			// Проверяем штрих-код на принадлежность к весовому типу
			$pr=mb_substr($term, 0, 2);
			if($pr==$sets['weight_code_pr'] && $term_len==13) {
				$barcode=$term;
				$term=mb_substr($barcode, 0, 7);
				$count=mb_substr($barcode, 7, 5);
				$count=numberformat(round($count/1000, 3), 3, '.', '');
			}

			if(!$not_add) {
				// Проверяем штрих-код на принадлежность к карте клиента
				if($pr==$sets['card_code_pr'] && $term_len==13) {
					$this->f3->reroute('/partners/search_result?q='.$term);
					return;
				}
			}

			if(!$not_add) {
				// Проверяем штрих-код на принадлежность к карте сотрудника
				if($pr==$sets['worker_code_pr'] && $term_len==13) {
					$this->f3->reroute('/receipts/walk?barcode='.$term);
					return;
				}
			}

			// проверяем дата-матрикс
			$data_matrix=$this->data_matrix($term);
			if($data_matrix['data_matrix']==true) {
				$term=$data_matrix['code'];
			}

			$limit=$this->f3->get('lines_of_page');
			$order=$this->f3->get('GET.order');
			if(!$order) {
				$order=false;
			}
			$res=$this->model->search($term, ($page-1)*$limit, $limit, false, $exact_match, $in_stock, $order);
		}
		
		if(empty($res['products'])) {
			if($data_matrix['data_matrix']==true) {
				$this->f3->set('GET.product_search', $data_matrix['code']);
				$this->f3->set('GET.marking', 1);
			}
			$this->f3->set('page_data', $this->model->page_data('not_found'));
			return;
		}
		elseif(count($res['products'])>1 || $not_add==1) {
			$this->f3->set('pagination', $this->pagination($res['count'], $page));
			$this->f3->set('products', $res['products']);
			$this->f3->set('page_data', $this->model->page_data('search'));
			$this->f3->set('search', $term);
		}
		elseif(count($res['products'])==1) {
			$mark='';
			if($data_matrix['data_matrix']) {
				//$mark.='&receipttype='.$this->f3->get('GET.type').'&mark='.json_encode(array(str_replace('&', '%26', str_replace('+', '%2B', str_replace('?', '%3f', $data_matrix['term'])))));
				$mark.='&receipttype='.$this->f3->get('GET.type').'&mark='.json_encode(array(base64_encode($data_matrix['term'])));
			}
			if(!$count) {
				$count=$res['products'][0]['quantity'];
			}
			$res=array(
				'success'=>true,
				'txt'=>$this->messages->message('loading')['txt'],
				//'close_all_window'=>true,
				'next_step'=>'/receipts/add_line?product_id='.$res['products'][0]['id'].'&count='.$count.$mark
			);
			if($mark=='') {
				$res['close_all_window']=true;
			}
			echo json_encode($res);
			exit();
		}
	}

	// Поиск товаров для печати ценников
	function pricetags() {
		$term=$this->f3->get('GET.product_search');
		$count=$this->f3->get('GET.coeff');
		
		$not_add=1;
		$this->f3->set('not_add', $not_add);
		
		$exact_match=$this->f3->get('GET.exact_match');
		$this->f3->set('exact_match', $exact_match);
		
		$in_stock=$this->f3->get('GET.in_stock');
		$this->f3->set('in_stock', $in_stock);

		$page=$this->f3->get('GET.page');
		if(!$page) $page=1;

		$limit=$this->f3->get('lines_of_page');
		$order=$this->f3->get('GET.order');
		if(!$order) {
			$order=false;
		}
		$res=$this->model->search($term, ($page-1)*$limit, $limit, false, $exact_match, $in_stock, $order);
		$this->f3->set('pagination', $this->pagination($res['count'], $page));
		$this->f3->set('products', $res['products']);
		$this->f3->set('page_data', $this->model->page_data('pricetags'));
		$this->f3->set('search', $term);
	}

	// Отображение быстрых товаров
	function fast_products() {
		$page=$this->f3->get('GET.page');
		if(!$page) $page=1;
		$limit=$this->f3->get('lines_of_page');
		$res=$this->model->fast_products(($page-1)*$limit, $limit);
		if(empty($res['products'])) {
			$this->f3->set('page_data', $this->messages->message('not_found'));
			return;
		}
		elseif(count($res['products'])>0) {
			$this->f3->set('pagination', $this->pagination($res['count'], $page));
			$this->f3->set('products', $res['products']);
			$this->f3->set('page_data', $this->model->page_data('fast_products'));
		}
	}

	// Показ картинки товара
	function img() {
		$img=$this->f3->get('GET.img');
		if(!$img) {
			$this->f3->set('page_data', $this->messages->message('not_found'));
		}
		else {
			$this->f3->set('img', '//'.$this->api_data['domen'].'/upload/'.$this->api_data['subdomen'].'/300_300/'.$img);
			$this->f3->set('page_data', $this->model->page_data('img'));
		}
	}

	// Узнаем остатки
	function currentstock() {
		$line_id=$this->f3->get('GET.line_id');
		if(!$line_id) {
			$this->f3->set('page_data', $this->model->page_data('search_form'));
		}
		else {
			// Узнаем id продукта
			$l=new \Models\Receiptlines($this->db, $this->f3);
			$line=$l->select_lines(array('id=?', $line_id), array('limit'=>1));
			if(empty($line)) {
				$this->f3->set('page_data', $this->messages->message('not_found'));
			}
			else {
				$prod=$this->model->select_product(array('p.id=?', $line[0]['product_id']), array('limit'=>1));
				if(empty($prod)) {
					$this->f3->set('page_data', $this->messages->message('not_found'));
				}
				else {
					$this->f3->set('product', $prod[0]);
					$this->f3->set('page_data', $this->model->page_data('currentstock'));
				}
			}
		}
	}

	// Список категорий и товаров
	function list($with_stop=true) {
		if(!is_bool($with_stop)) $with_stop=true;
		$c=new \Models\Productcategories($this->db, $this->f3);
		$category_id=$this->f3->get('GET.category_id');
		$parent=array();
		$lines_of_list=$this->sets['lines_of_list'];
		$fast=$this->model->count('fast=1 AND date_delete=0');
		if($fast && !$category_id && $this->sets['cafe_mode']==1) {
			$lines_of_list-=1;
		}
		$this->f3->set('fast', $fast);
		if(!$category_id) {
			$category_id=0;
		}
		else {
			if($this->sets['product_menu']==1) {
				$lines_of_list-=2;
			}
			// Узнаем название родительской категории, если она есть
			$parent=$c->select_productcategories(array('id=? AND date_delete=0', $category_id), array('limit'=>1));
		}
		$this->f3->set('parent', $parent[0]);
		$page=$this->f3->get('GET.page');
		if(!$page) $page=1;
		$this->f3->set('page', $page);

		// Получаем категории
		$kiosk_where='';
		if($this->f3->get('authorization_user.kiosk')==1) {
			$kiosk_where=' AND kiosk_noshow=0';
		}
		$categories=$c->select_productcategories(array('parent_id=? AND show=1 AND date_delete=0'.$kiosk_where, $category_id), array('order'=>'title', 'offset'=>($page-1)*$lines_of_list, 'limit'=>$lines_of_list));
		$this->f3->set('categories', $categories);
		$products=array();
		// сколько всего категорий
		$cat_all=$c->count(array('parent_id=? AND date_delete=0 AND show=1', $category_id));
		// Узнаем надо ли загрузить товары, чтобы добить число позиций на странице до 10
		$cat_count=count($categories);

		$with_stop_where='';
		if(!$with_stop) {
			$with_stop_where=' AND (stop=0 OR stop IS NULL)';
		}
		if($cat_count<$lines_of_list) {
			// Узнаем позицию начала товаров
			// Начало выборки
			$cat_page=intdiv($cat_all, $lines_of_list); // Сколько страниц полностью занято категориями
			$cat_last_page=$cat_all%$lines_of_list; // Сколько категорий на последней странице с категориями

			$prod_page=$page-$cat_page;// Сколько страниц было с товарами
			$prod_first_page=$lines_of_list-$cat_last_page; // Сколько товаров было на первой странице с товарами
			// Считаем начало выборки товаров
			if($prod_page==1) {// Если это первая странице где появляются товары
				$offset=0;
				$limit=$lines_of_list-$cat_last_page;
			}
			else {
				$offset=($prod_page-2)*$lines_of_list+$prod_first_page;
				$limit=$lines_of_list;
			}
			$products=$this->model->select_product(array('category_id=? AND p.parent_id=0 '.$with_stop_where, $category_id), array('order'=>'title', 'limit'=>$offset.', '.$limit));
		}
		$this->f3->set('products', $products);
		// Узнаем сколько всего товаров
		$prods_all=$this->model->count(array('category_id=? AND parent_id=0 AND date_delete=0'.$with_stop_where, $category_id));
		// Кол-во страниц всего
		$page_all=ceil(($cat_all+$prods_all)/$lines_of_list); //Сколько всего должно быть страниц
		$this->f3->set('page_all', $page_all);

		$receipt_id=$this->f3->get('COOKIE.receipt_id');
		if($receipt_id>0){
			$r=new \Models\Receipts($this->db, $this->f3);
			$r->reset();
			$r->load(array('id=?', $receipt_id), array('limit'=>1));
			$this->f3->set('receipt', $r->cast());
		}

		$this->f3->set('page_data', $this->model->page_data('list'));
	}

	// Страница информации о товаре для клиента
	function barcode() {
		$barcode=$this->f3->get('GET.barcode');

		$s=new \Models\Settings($this->f3, $this->db);
		$sets=$s->get_settings(array('weight_code_pr'));
		// Проверяем штрих-код на принадлежность к весовому типу
		if(mb_substr($barcode, 0, 2)==$sets['weight_code_pr'] && mb_strlen($barcode)==13) {
			$barcode=mb_substr($barcode, 0, 7);
		}

		$product=$this->model->barcode($barcode);
		$product['txt']=$this->messages->message($product['txt'])['txt'];
		if($product['img']) {
			$product['img']='https://'.$this->api_data['domen'].'/upload/'.$this->api_data['subdomen'].'/'.$product['img'];
		}
		echo json_encode($product);
		exit();
	}

	// Форма добавления нового товара
	function form() {
		$inc='add';
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', false);
		$this->f3->set('sno_org', $fr->sets['sno']);
		$c=new \Models\Productcategories($this->db, $this->f3);
		$this->f3->set('categories', $c->categories_list());
		$title=$this->f3->get('GET.title');
		$product['marking']=$this->f3->get('GET.marking');
		$id=$this->f3->get('GET.id');
		if(is_numeric($title)) {
			$product['barcode']=$title;
			$market_product=$this->model->market_search($title);
			if($market_product) {
				$product['title']=$market_product['title'];
			}
		}
		else {
			$product['title']=$title;
		}
		if($id) {
			$data=$this->model->select_product(array('p.id=? AND p.date_delete=0', $id), array('limit'=>1));
			if($data) {
				$data[0]['barcode']=$this->model->barcodes($id)[0]['barcode'];
				$product=$data[0];
			}
			else {
				$this->f3->set('page_data', $this->messages->message('not_found'));
				return;
			}
			$inc='change';
		}
		$fr=new \Models\Fr($this->db, $this->f3, 'kkm', false);
		//$product['sno']=$fr->sets['sno'];
		$this->f3->set('data', $product);
		$this->f3->set('units', $this->model->units);
		$this->f3->set('page_data', $this->model->page_data($inc));
	}

	// Добавление нового товара в чек
	function post_form() {
		$post['date_delete']=0;
		$post=$this->f3->get('POST');

		if($post['id'])$action='change';
		else $action='add';

		if(!$this->sets['autonomous'] && $action=='add') {
			$post['id']=-time();
		}

		$post['short_title']=$post['title'];
		$result=$this->model->save_product($post, $action);
		if(!$result['success']) {
			$result['txt']=$this->messages->message($result['txt'])['txt'];
			echo json_encode($result);
			exit();
		}
		if($result['success'] && isset($post['product_id'])) {
			$post['product_id']=$result['id'];
		}

		if(isset($post['product_id'])) {
			if($post['vat_type']>0) {
				$post['price']=round($post['price']/(1+$post['vat']/100), 2);
			}
			$line=array(
				'title'=>$post['title'],
				'id'=>$post['product_id'],
				'price'=>$post['price'],
				'vat'=>$post['vat'],
				'vat_type'=>$post['vat_type'],
				'units_fr'=>$this->model->units[$post['units']]['number'],
				'other_info'=>json_encode(
					$post
				)
			);
			if($post['marking']) {
				$result['next_step']='/receipts/add_line?product_id='.$post['product_id'].'&count=1';
				$result['txt']=$this->messages->message($result['txt'])['txt'];
				echo json_encode($result);
				exit();
			}
			$receiptlines=new \Models\Receiptlines($this->db, $this->f3);
			$receipt_id=$this->f3->get('COOKIE.receipt_id');
			$result=$receiptlines->add_line($receipt_id, $line, $post['count']);
			if($this->sets['line_merge']) {
				$receiptlines->linesmerge($line['id']);
			}
			if($result['success']) {
				if(!$this->cd) {
					$this->cd=new \Models\Cd($this->db, $this->f3);
				}
				$this->cd->print_line($result['line'], $count);
			}
		}
		$result['txt']=$this->messages->message($result['txt'])['txt'];
		echo json_encode($result);
		exit();
	}

	function directory() {
		$page=$this->f3->get('GET.page');
		if(!$page) $page=1;
		$limit=$this->f3->get('lines_of_page');
		$products=$this->model->select_product(array('p.date_delete=0'), array('offset'=>($page-1)*$limit, 'limit'=>$limit, 'order'=>'title'));
		$this->f3->set('data', $products);
		if($products) {
			$this->f3->set('pagination', $this->pagination($this->model->count('date_delete=0'), $page));
		}
		$this->f3->set('page_data', $this->model->page_data('directory'));
	}

	function delete() {
		$id=$this->f3->get('GET.id');
		$res=$this->model->delete($id);
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
		exit();
	}

	function detail() {
		$id=$this->f3->get('GET.id');
		$page_data=$this->model->page_data('detail');
		$products=$this->model->select_product(array('p.date_delete=0 AND p.id=?', $id), array('limit'=>1));
		if($products) {
			$products[0]['img']=json_decode($products[0]['img'], true);
			$this->f3->set('product', $products[0]);
			$page_data['title']=$products[0]['title'];
		}
		$this->f3->set('page_data', $page_data);
	}

	function stoplist() {
		$page=$this->f3->get('GET.page');
		if(!$page) $page=1;
		$limit=$this->f3->get('lines_of_page');
		$products=$this->model->select_product(array('p.date_delete=0 AND p.stop=1'), array('offset'=>($page-1)*$limit, 'limit'=>$limit, 'order'=>'title'));
		$this->f3->set('products', $products);
		if($products) {
			$this->f3->set('pagination', $this->pagination($this->model->count('date_delete=0 AND stop=1'), $page));
		}
		$this->f3->set('page_data', $this->model->page_data('stoplist'));
	}

	function addstop() {
		$this->sets['lines_of_list']=$this->f3->get('lines_of_page');
		$this->list(false);
		$this->f3->set('page_data', $this->model->page_data('addstop'));
	}

	function post_changestop() {
		$post=$this->f3->get('POST');
		$res=$this->model->save_product($post, 'change');
		if($res['success']) {
			$api=new \Models\Api($this->f3, $this->api_data['domen'], $this->api_data['pass'], $this->api_data['store_id'], $this->api_data['count']);
			$api->changestop($post);
		}
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
	}

	function deletestop() {
		$product=$this->model->select_product(array('p.id=?', $this->f3->get('GET.id')), array('limit'=>1));
		if(!$product) {
			$this->f3->set('page_data', $this->messages->message('not_found'));
			return;
		}
		$this->f3->set('product', $product[0]);
		$this->f3->set('page_data', $this->model->page_data('deletestop'));
	}

	function clearstop() {
		$res=$this->model->clearstop();
		if($res['success']) {
			$api=new \Models\Api($this->f3, $this->api_data['domen'], $this->api_data['pass'], $this->api_data['store_id'], $this->api_data['count']);
			$api->clearstop();
		}
		$res['txt']=$this->messages->message($res['txt'])['txt'];
		echo json_encode($res);
	}

	function searchstop() {
		$this->search_barcodes();
		$this->f3->set('page_data', $this->model->page_data('searchstop'));
	}
}