<?php
namespace Models;

class android_inpas {
  public $f3, $sets, $config;
  public $errors=array(
    -1=>'Неизвестная ошибка',
    0=>'DC не смог передать ответ от терминала. Возможная причина, внутренняя ошибка DC',
    1=>'Истекло время исполнения операции. Устанавливаемое полем «timeout» в запросе',
    3=>'Общая ошибка, ошибка параметров DC, не поддерживаемый метод HTTP,
неизвестная ошибка, ошибка во время работы DC',
    4=>'Ошибка поля или ошибка запроса, как между кассой и DC, так и между DC и
терминалом',
    13=>'Ошибка обмена данными между DC и терминалом. Возможная причина в отсутствии
устройства или ответ не по протоколу SA',
    15=>'Обмен данными прерван, например, выключение DC, мониторинг подключения
устройства или отменен другим обменом',
    16=>'Устройство занято, например, занято другим обменом'
  );

  function __construct($f3, $sets, $config) {
    $this->f3=$f3;
    $this->sets=$sets;
    if(!$config['Sale']) $config['Sale']=1;
    if(!$config['Return']) $config['Return']=29;
    if(!$config['Cancel']) $config['Cancel']=4;
    if(!$config['Close']) $config['Close']=59;
    if(!$config['X']) $config['X']=63;
    if(!$config['Test']) $config['Test']=26;
    if(!$config['URL']) $config['URL']='http://localhost:9015';
    $this->config=$config;
  }


  // Отправка задания
  function send_cmd($xml, $ok_field=39) {
    $url=$this->config['URL'].'/requests';
    $headers=array(
      'Accept: text/xml',
      'Accept-Encoding: identity',
      'Content-Type: text/xml; charset=windows-1251'
    );
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL,$url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_POST,true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, iconv('utf-8', 'windows-1251//IGNORE', $xml));
    $data = curl_exec($curl);
    curl_close($curl);

    if(!$data) {
      return array(
        'success'=>false,
        'txt'=>'Нет ответа от терминала'
      );
    }

    $data=str_replace('windows-1251', 'utf-8', $data);
    $data=iconv('windows-1251', 'utf-8', $data);

    $xml=new \SimpleXMLElement($data);

    if(!$xml) {
      return array(
        'success'=>false,
        'txt'=>$data
      );
    }

    if(isset($xml->errorcode)) {
      if(isset($this->errors[(int)$xml->errorcode])) {
        $error=$this->errors[(int)$xml->errorcode];
      }
      else {
        $error=$this->errors[-1];
      }
      return array(
        'success'=>false,
        'txt'=>$error
      );
    }

    foreach ($xml->field as $key => $field) {
      $field['id']=(int)$field['id'];
      if($field['id']==10) {
        $pan=trim($field);
      }

      if($field['id']==13) {
        $authcode=trim($field);
      }

      if($field['id']==14) {
        $transid=trim($field);
      }

      if($field['id']==19) {
        $status_txt=trim($field);
      }

      if($field['id']==$ok_field) {
        if((int)trim($field)===1) {
          $success=true;
        }
        else {
          $success=false;
          $status_code=trim($field);
        }
      }

      if($field['id']==90) {
        if (!preg_match('//u', $field)) {
          $field=iconv("windows-1251","utf-8",$field);
        }
        $slips=explode('0xDA^^', $field);
        $slips[0]=str_replace('0xDF^^', '' , $slips[0]);
        if(!$slips[1]) {
          $slips[1]=$slips[0];
        }
      }
    }

    if($success) {
      return array(
        'success'=>true,
        'txt'=>nl2br($slips[0]),
        'slip'=>nl2br($slips[1]),
        'pan'=>$pan,
        'transid'=>$transid,
        'authcode'=>$authcode
      );
    }
    else {
      return array(
        'success'=>false,
        'txt'=>nl2br($status_txt).'<br>Код статуса: '.$status_code
      );
    }
  }

  function ticket($type, $sum, $return_bt=null) {
    if($type=='sale') {
      $operation=$this->config['Sale'];
    }
    elseif($type=='return') {
      $operation=$this->config['Return'];
    }
    else {
      $operation=$this->config['Cancel'];
    }

    $xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
    $xml.="<request>\n";
    $xml.="<field id=\"00\">".($sum*100)."</field>\n";
    $xml.="<field id=\"04\">643</field>\n";
    if($type=='return') {
      $xml.="<field id=\"13\">".$return_bt['authcode']."</field>\n";
    }
    $xml.="<field id=\"25\">".$operation."</field>\n";
    if($type!='sale') {
      $xml.="<field id=\"26\">".$return_bt['transid']."</field>\n";
    }
    if($this->config['TerminalID']) {
      $xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
    }
    $xml.="</request>\n";
    return $this->send_cmd($xml);
  }

  function z() {
    $xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
    $xml.="<request>\n";
    $xml.="<field id=\"25\">".$this->config['Close']."</field>\n";
    if($this->config['TerminalID']) {
      $xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
    }
    $xml.="</request>\n";
    return $this->send_cmd($xml);
  }

  function x() {
    $xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
    $xml.="<request>\n";
    $xml.="<field id=\"25\">".$this->config['X']."</field>\n";
    $xml.="<field id=\"65\">20</field>\n";
    if($this->config['TerminalID']) {
      $xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
    }
    $xml.="</request>\n";
    return $this->send_cmd($xml, 67);
  }

  function testconnection() {
    $xml="<?xml version=\"1.0\" encoding=\"windows-1251\"?>\n";
    $xml.="<request>\n";
    $xml.="<field id=\"25\">".$this->config['Test']."</field>\n";
    if($this->config['TerminalID']) {
      $xml.="<field id=\"27\">".$this->config['TerminalID']."</field>\n";
    }
    $xml.="</request>\n";
    return $this->send_cmd($xml);
  }
}
